package org.eclipse.persistence.testing.jaxb.beanvalidation.special;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* ****************************************************************************
* Copyright (c) 2014 Oracle and/or its affiliates. All rights reserved.
* This program and the accompanying materials are made available under the
* terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
* which accompanies this distribution.
* The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
* and the Eclipse Distribution License is available at
* http://www.eclipse.org/org/documents/edl-v10.php.
* <p/>
* Contributors:
* Marcel Valovy - initial API and implementation
* ****************************************************************************
*/
@Target({ ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = CustomAnnotationValidator.class)
public @interface CustomAnnotation {

    String message() default "{org.eclipse.persistence.moxy.CustomAnnotation.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
