/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.io.File;
import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class DefaultSessionLogAdapter
extends LogAdapter {
    public static final String FILE_NAME_PROPERTY = "filename";
    public static final String LOG_LEVEL_PROPERTY = "logLevel";
    public static final String INFO_LOG_LEVEL = "info";
    public static final String SEVERE_LOG_LEVEL = "severe";
    public static final String WARNING_LOG_LEVEL = "warning";
    public static final String CONFIG_LOG_LEVEL = "config";
    public static final String FINE_LOG_LEVEL = "fine";
    public static final String FINER_LOG_LEVEL = "finer";
    public static final String FINEST_LOG_LEVEL = "finest";
    public static final String ALL_LOG_LEVEL = "all";
    public static final String OFF_LOG_LEVEL = "off";
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final String DEFAULT_LOG_FILE = "standard output";
    public static final String[] VALID_LOG_LEVEL = new String[]{"config", "info", "warning", "severe", "fine", "finer", "finest", "all", "off"};

    DefaultSessionLogAdapter(SCAdapter parent, DefaultSessionLogConfig scConfig) {
        super(parent, (LogConfig)scConfig);
    }

    protected DefaultSessionLogAdapter(SCAdapter parent, String fileName, String logLevel) {
        super(parent);
        this.setFileName(fileName);
        this.setLogLevel(logLevel);
    }

    @Override
    protected Object buildModel() {
        return new DefaultSessionLogConfig();
    }

    public String getFileName() {
        String name = this.getFileNameInternal();
        if (name != null) {
            name = name.replace('/', File.separatorChar);
        }
        return name;
    }

    private String getFileNameInternal() {
        String name = this.log().getFilename();
        if (name == null) {
            name = DEFAULT_LOG_FILE;
        }
        return name;
    }

    public void setFileName(String name) {
        String old = this.log().getFilename();
        String newName = name;
        if (newName != null) {
            newName = newName.replace('\\', '/');
        }
        this.setFilenameInternal(newName);
        this.firePropertyChanged(FILE_NAME_PROPERTY, old, name);
    }

    private void setFilenameInternal(String name) {
        if (name != null && name.equals(DEFAULT_LOG_FILE)) {
            this.log().setFilename(null);
        } else {
            this.log().setFilename(name);
        }
    }

    public String getLogLevel() {
        return this.log().getLogLevel();
    }

    public void setLogLevel(String logLevel) {
        String old = this.getLogLevel();
        this.log().setLogLevel(logLevel);
        this.firePropertyChanged(LOG_LEVEL_PROPERTY, old, logLevel);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getFileName());
    }

    private final DefaultSessionLogConfig log() {
        return (DefaultSessionLogConfig)this.getModel();
    }

    protected void addProblemsTo(List branchProblems) {
        super.addProblemsTo(branchProblems);
        this.verifyProblemFileName(branchProblems);
    }

    private void verifyProblemFileName(List branchProblems) {
        String fileName = this.getFileName();
        if (!DEFAULT_LOG_FILE.equals(fileName) && StringTools.stringIsEmpty((String)fileName)) {
            branchProblems.add(this.buildProblem("0807", this.getParent().displayString()));
        }
    }
}

