/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryKeyHandle
extends MWHandle {
    private volatile MWQueryKey queryKey;
    private volatile String descriptorName;
    private volatile String queryKeyName;

    private MWQueryKeyHandle() {
    }

    public MWQueryKeyHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWQueryKeyHandle(MWModel parent, MWQueryKey queryKey, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.queryKey = queryKey;
    }

    public MWQueryKey getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(MWQueryKey queryKey) {
        this.queryKey = queryKey;
    }

    @Override
    protected Node node() {
        return this.getQueryKey();
    }

    public MWQueryKeyHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void resolveColumnHandles() {
        MWRelationalDescriptor descriptor;
        super.resolveColumnHandles();
        if (this.descriptorName != null && this.queryKeyName != null && (descriptor = (MWRelationalDescriptor)((Object)this.getProject().descriptorNamed(this.descriptorName))) != null) {
            this.queryKey = descriptor.queryKeyNamed(this.queryKeyName);
        }
        this.descriptorName = null;
        this.queryKeyName = null;
    }

    public int compareTo(Object o) {
        return this.queryKey.compareTo(((MWQueryKeyHandle)o).queryKey);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.queryKey == null) {
            sb.append("null");
        } else {
            sb.append(this.queryKey.getName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryKeyHandle.class);
        descriptor.addDirectMapping("descriptorName", "getDescriptorNameForTopLink", "setDescriptorNameForTopLink", "descriptor-name/text()");
        descriptor.addDirectMapping("queryKeyName", "getQueryKeyNameForTopLink", "setQueryKeyNameForTopLink", "query-key-name/text()");
        return descriptor;
    }

    private String getDescriptorNameForTopLink() {
        return this.queryKey == null ? null : this.queryKey.getDescriptor().getName();
    }

    private void setDescriptorNameForTopLink(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    private String getQueryKeyNameForTopLink() {
        return this.queryKey == null ? null : this.queryKey.getName();
    }

    private void setQueryKeyNameForTopLink(String queryKeyName) {
        this.queryKeyName = queryKeyName;
    }
}

