/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepositoryFactory;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TreeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassRepository
extends MWModel
implements ProjectSubFileComponentContainer {
    private Map types;
    private Map typeNames;
    private Set userTypes;
    public static final String USER_TYPES_COLLECTION = "userTypes";
    private Collection userTypeNames;
    private static final String USER_TYPE_NAMES_COLLECTION = "userTypeNames";
    private volatile ExternalClassRepository externalClassRepository;
    private List classpathEntries;
    public static final String CLASSPATH_ENTRIES_LIST = "classpathEntries";
    private static final Class[] CORE_KEYS = new Class[]{Object.class, List.class, Map.class, Collection.class, Set.class, ValueHolderInterface.class};
    private static Set coreClassNames;
    private static Map coreClassNamesLowerCase;
    private static final String SUB_DIRECTORY_NAME = "classes";
    private boolean persistLastRefresh;
    public static final String PERSIST_LAST_REFRESH_PREFERENCE = "last refresh";
    public static final boolean PERSIST_LAST_REFRESH_PREFERENCE_DEFAULT = true;

    private MWClassRepository() {
    }

    public MWClassRepository(MWProject project) {
        super(project);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.types = new Hashtable();
        this.typeNames = new Hashtable();
        this.userTypes = Collections.synchronizedSet(new HashSet());
        this.classpathEntries = new Vector();
        this.userTypeNames = new HashSet();
        this.persistLastRefresh = true;
    }

    private void setTypes(Collection types) {
        this.types = new Hashtable(types.size());
        this.typeNames = new Hashtable(types.size());
        Iterator stream = types.iterator();
        while (stream.hasNext()) {
            this.addType((MWClass)stream.next());
        }
        this.userTypes = Collections.synchronizedSet(new HashSet(types));
    }

    private void addType(MWClass type) {
        this.addType(type.getName(), type);
    }

    private void addType(String typeName, MWClass type) {
        MWClass previousType = this.types.put(typeName, type);
        if (previousType != null) {
            this.types.put(typeName, previousType);
            throw new IllegalArgumentException("duplicate types: " + previousType + " vs. " + type);
        }
        String previousTypeName = this.typeNames.put(typeName.toLowerCase(), typeName);
        if (previousTypeName != null) {
            this.types.remove(typeName);
            this.typeNames.put(typeName.toLowerCase(), previousTypeName);
            throw new IllegalArgumentException("type names cannot differ only by case: " + previousTypeName + " vs. " + typeName);
        }
    }

    private void removeType(MWClass type) {
        this.removeTypeNamed(type.getName());
        this.removeUserType(type);
    }

    private MWClass removeTypeNamed(String typeName) {
        Object previousTypeName = this.typeNames.remove(typeName.toLowerCase());
        if (previousTypeName == null) {
            throw new IllegalArgumentException("missing type name: " + typeName);
        }
        if (!previousTypeName.equals(typeName)) {
            this.typeNames.put(typeName.toLowerCase(), previousTypeName);
            throw new IllegalArgumentException("inconsistent type names: " + previousTypeName + " vs. " + typeName);
        }
        MWClass previousType = (MWClass)this.types.remove(typeName);
        if (previousType == null) {
            this.typeNames.put(typeName.toLowerCase(), previousTypeName);
            throw new IllegalArgumentException("missing type: " + typeName);
        }
        return previousType;
    }

    public Iterator userTypes() {
        return new CloneIterator(this.userTypes);
    }

    public int userTypesSize() {
        return this.userTypes.size();
    }

    private void addUserType(MWClass userType) {
        this.addItemToCollection(userType, this.userTypes, USER_TYPES_COLLECTION);
    }

    private void removeUserType(MWClass userType) {
        this.removeItemFromCollection(userType, this.userTypes, USER_TYPES_COLLECTION);
    }

    private ExternalClassRepository getExternalClassRepository() {
        if (this.externalClassRepository == null) {
            this.externalClassRepository = this.buildExternalClassRepository();
        }
        return this.externalClassRepository;
    }

    private ExternalClassRepository buildExternalClassRepository() {
        return this.externalClassRepositoryFactory().buildClassRepository(this.buildExternalClassRepositoryClasspath());
    }

    public ListIterator classpathEntries() {
        return new CloneListIterator(this.classpathEntries);
    }

    public int classpathEntriesSize() {
        return this.classpathEntries.size();
    }

    public String getClasspathEntry(int index) {
        return (String)this.classpathEntries.get(index);
    }

    public void addClasspathEntry(int index, String entry) {
        this.addItemToList(index, entry, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
    }

    public void addClasspathEntry(String entry) {
        this.addClasspathEntry(this.classpathEntriesSize(), entry);
    }

    public void addClasspathEntries(int index, List entries) {
        this.addItemsToList(index, entries, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
    }

    public void addClasspathEntries(List entries) {
        this.addClasspathEntries(this.classpathEntriesSize(), entries);
    }

    public void addClasspathEntries(ListIterator entries) {
        this.addClasspathEntries(CollectionTools.list(entries));
    }

    public String removeClasspathEntry(int index) {
        String result = (String)this.removeItemFromList(index, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
        return result;
    }

    public List removeClasspathEntries(int index, int length) {
        List result = this.removeItemsFromList(index, length, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
        return result;
    }

    public String replaceClasspathEntry(int index, String newEntry) {
        String result = (String)this.setItemInList(index, newEntry, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
        return result;
    }

    private ExternalClassRepositoryFactory externalClassRepositoryFactory() {
        return this.getProject().getSPIManager().getExternalClassRepositoryFactory();
    }

    public Iterator externalClassDescriptions() {
        return new ArrayIterator(this.getExternalClassRepository().getClassDescriptions());
    }

    public Iterator externalReferenceClassDescriptions() {
        return this.referenceTypes(this.externalClassDescriptions());
    }

    private ExternalClassDescription externalClassDescriptionNamed(String name) {
        return this.getExternalClassRepository().getClassDescription(name);
    }

    Iterator externalClassDescriptionsNamed(final String name) {
        return new FilteringIterator(this.externalClassDescriptions()){

            @Override
            public boolean accept(Object next) {
                return ((ExternalClassDescription)next).getName().equals(name);
            }

            @Override
            public String toString() {
                return "MWClassRepository.externalClassDescriptionsNamed(String)";
            }
        };
    }

    public Iterator combinedTypes() {
        return new CompositeIterator((Iterator)new CloneIterator(this.userTypes), this.externalClassDescriptions());
    }

    public Iterator combinedReferenceTypes() {
        return this.referenceTypes(this.combinedTypes());
    }

    public Iterator uniqueCombinedTypes() {
        return this.uniqueTypes(this.combinedTypes());
    }

    public Iterator uniqueCombinedReferenceTypes() {
        return this.uniqueTypes(this.combinedReferenceTypes());
    }

    private Iterator uniqueTypes(Iterator originalTypes) {
        return new FilteringIterator(originalTypes){
            private Set usedNames;
            {
                this.usedNames = new HashSet(10000);
            }

            @Override
            protected boolean accept(Object next) {
                return this.usedNames.add(((ClassDescription)next).getName());
            }

            @Override
            public String toString() {
                return "MWClassRepository.uniqueTypes(Iterator)";
            }
        };
    }

    private Iterator referenceTypes(Iterator originalTypes) {
        return new FilteringIterator(originalTypes){

            @Override
            protected boolean accept(Object next) {
                return !MWClass.nonReferenceClassNamesContains(((ClassDescription)next).getName());
            }

            @Override
            public String toString() {
                return "MWClassRepository.referenceTypes(Iterator)";
            }
        };
    }

    File classpathBaseDirectory() {
        return this.getProject().getSaveDirectory();
    }

    private File[] buildExternalClassRepositoryClasspath() {
        List<String> coreFiles = MWClassRepository.buildCoreClassLocations();
        ArrayList<File> files = new ArrayList<File>(this.classpathEntriesSize() + coreFiles.size());
        CollectionTools.addAll(files, this.fullyQualifiedClasspathFiles());
        ListIterator<String> coreFileIter = coreFiles.listIterator();
        while (coreFileIter.hasNext()) {
            files.add(new File(coreFileIter.next()));
        }
        return files.toArray(new File[files.size()]);
    }

    private Iterator fullyQualifiedClasspathFiles() {
        return new TransformationIterator(this.classpathEntries()){

            @Override
            protected Object transform(Object next) {
                File file = new File((String)next);
                if (!file.isAbsolute()) {
                    file = new File(MWClassRepository.this.classpathBaseDirectory(), file.getPath());
                }
                return file;
            }

            @Override
            public String toString() {
                return "MWClassRepository.fullyQualifiedClasspathFiles()";
            }
        };
    }

    public Iterator fullyQualifiedClasspathEntries() {
        return new TransformationIterator(this.fullyQualifiedClasspathFiles()){

            @Override
            protected Object transform(Object next) {
                return ((File)next).getAbsolutePath();
            }

            @Override
            public String toString() {
                return "MWClassRepository.fullyQualifiedClasspathEntries()";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator subclassesOf(MWClass type) {
        ArrayList<MWClass> subclasses = new ArrayList<MWClass>();
        Map map = this.types;
        synchronized (map) {
            for (MWClass next : this.types.values()) {
                if (next.getSuperclass() != type) continue;
                subclasses.add(next);
            }
        }
        return subclasses.iterator();
    }

    public Iterator allSubclassesOf(MWClass type) {
        return new TreeIterator(type){

            @Override
            protected Iterator children(Object next) {
                return ((MWClass)next).subclasses();
            }

            @Override
            public String toString() {
                return "MWClassRepository.allSubclassesOf(MWClass)";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWClass typeNamedIgnoreCase(String typeName) {
        Map map = this.types;
        synchronized (map) {
            return this.typeNamedIgnoreCase2(typeName);
        }
    }

    private MWClass typeNamedIgnoreCase2(String typeName) {
        if ((typeName = (String)this.typeNames.get(typeName.toLowerCase())) == null) {
            return null;
        }
        MWClass type = (MWClass)this.types.get(typeName);
        return this.typeIsGarbage(type) ? null : type;
    }

    private boolean typeIsGarbage(MWClass type) {
        Iterator stream = this.getProject().branchReferences();
        while (stream.hasNext()) {
            Node.Reference ref = (Node.Reference)stream.next();
            if (!ref.getTarget().isDescendantOf(type)) continue;
            return false;
        }
        this.removeType(type);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWClass typeNamedInternal(String typeName) {
        Map map = this.types;
        synchronized (map) {
            return this.typeNamedInternal2(typeName);
        }
    }

    private MWClass typeNamedInternal2(String typeName) {
        if (typeName == null) {
            throw new NullPointerException();
        }
        MWClass type = (MWClass)this.types.get(typeName = typeName.trim());
        if (type != null) {
            return type;
        }
        boolean coreType = this.checkTypeName(typeName);
        type = new MWClass(this, typeName, coreType);
        this.addType(typeName, type);
        type.initializeNameDependentState();
        if (coreType) {
            this.buildCoreType(type);
        }
        return type;
    }

    private boolean checkTypeName(String typeName) {
        if (typeName.length() == 0) {
            throw new IllegalArgumentException("empty type name");
        }
        if (ClassTools.classNamedIsArray(typeName)) {
            throw new IllegalArgumentException("use MWTypeDeclaration for array types");
        }
        if (MWClassRepository.coreClassNamesContains(typeName)) {
            return true;
        }
        String collision = MWClassRepository.coreClassNameIgnoreCase(typeName);
        if (collision != null) {
            throw new IllegalArgumentException("case-insensitive name collision with \"core\" type: " + collision);
        }
        return false;
    }

    public Iterator primitiveTypes() {
        return new TransformationIterator(MWClass.primitiveClassNames()){

            @Override
            protected Object transform(Object next) {
                return MWClassRepository.this.typeNamedInternal((String)next);
            }

            @Override
            public String toString() {
                return "MWClassRepository.primitiveTypes()";
            }
        };
    }

    public MWClass voidType() {
        return this.typeNamedInternal(MWClass.voidClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String resourceName) {
        Classpath cp;
        List list = this.classpathEntries;
        synchronized (list) {
            cp = new Classpath(this.classpathEntries);
        }
        return new URLClassLoader(cp.urls()).findResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Map map = this.types;
        synchronized (map) {
            children.addAll(this.types.values());
        }
    }

    void typeChanged(MWClass type) {
        if (type.isCoreType()) {
            return;
        }
        if (type.isStub()) {
            this.removeUserType(type);
        } else {
            this.addUserType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void typeRenamed(String oldName, String newName) {
        MWClass type;
        if (this.checkTypeName(newName)) {
            throw new IllegalArgumentException("type cannot be renamed to a \"core\" type");
        }
        Map map = this.types;
        synchronized (map) {
            type = this.removeTypeNamed(oldName);
            this.addType(newName, type);
        }
        if (this.userTypes.contains(type)) {
            this.fireCollectionChanged(USER_TYPE_NAMES_COLLECTION);
        }
    }

    void refreshType(MWClass type) throws ExternalClassNotFoundException {
        this.refreshType(type, DefaultMWClassRefreshPolicy.instance());
    }

    void refreshType(MWClass type, MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException {
        ExternalClassDescription exClassDescription = this.externalClassDescriptionNamed(type.getName());
        if (exClassDescription == null) {
            throw new ExternalClassNotFoundException(type.getName());
        }
        type.refresh(exClassDescription.getExternalClass(), refreshPolicy);
    }

    void refreshTypeMembers(MWClass type, MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException {
        ExternalClassDescription exClassDescription = this.externalClassDescriptionNamed(type.getName());
        if (exClassDescription == null) {
            throw new ExternalClassNotFoundException(type.getName());
        }
        type.refreshMembers(exClassDescription.getExternalClass(), refreshPolicy);
    }

    public void refreshExternalClassDescriptions() {
        this.externalClassRepository = null;
    }

    public void refreshTypeNamed(String typeName) throws ExternalClassNotFoundException {
        this.typeNamedInternal(typeName).refresh();
    }

    public void refreshTypeFor(ExternalClassDescription externalClassDescription) throws ExternalClassNotFoundException {
        this.typeNamedInternal(externalClassDescription.getName()).refresh(externalClassDescription.getExternalClass());
    }

    public void refreshTypesFor(Iterator externalClassDescriptions, ExternalClassLoadFailureListener listener) {
        while (externalClassDescriptions.hasNext()) {
            ExternalClassDescription externalClassDescription = (ExternalClassDescription)externalClassDescriptions.next();
            try {
                this.refreshTypeFor(externalClassDescription);
            }
            catch (ExternalClassNotFoundException ex) {
                listener.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, externalClassDescription.getName(), ex));
            }
        }
    }

    public ExternalClassLoadFailureContainer refreshTypesFor(Iterator externalClassDescriptions) {
        ExternalClassLoadFailureContainer listener = new ExternalClassLoadFailureContainer();
        this.refreshTypesFor(externalClassDescriptions, listener);
        return listener;
    }

    public void refreshTypes(Iterator refreshTypes, ExternalClassLoadFailureListener listener) {
        while (refreshTypes.hasNext()) {
            MWClass type = (MWClass)refreshTypes.next();
            try {
                this.refreshType(type);
            }
            catch (ExternalClassNotFoundException ecnfe) {
                listener.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, type.getName(), ecnfe));
            }
        }
    }

    public ExternalClassLoadFailureContainer refreshTypes(Iterator refreshTypes) {
        ExternalClassLoadFailureContainer listener = new ExternalClassLoadFailureContainer();
        this.refreshTypes(refreshTypes, listener);
        return listener;
    }

    private void buildCoreType(MWClass coreType) {
        try {
            ExternalClassDescription externalClassDescription = this.externalClassDescriptionNamed(coreType.getName());
            ExternalClass externalClass = externalClassDescription.getExternalClass();
            coreType.refreshDeclaration(externalClass);
        }
        catch (ExternalClassNotFoundException ex) {
            throw new RuntimeException(coreType.getName(), ex);
        }
    }

    void hierarchyChanged(MWClass type) {
        Iterator stream = this.allSubclassesOf(type);
        while (stream.hasNext()) {
            ((MWClass)stream.next()).superclassesChanged();
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRemoved(node);
        }
    }

    @Override
    public void nodeRenamed(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRenamed(node);
        }
    }

    @Override
    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
    }

    @Override
    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
    }

    @Override
    public void descriptorUnmapped(Collection mappings) {
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.types.size());
        sb.append(" types/");
        sb.append(this.userTypes.size());
        sb.append(" user types");
    }

    @Override
    public Iterator projectSubFileComponents() {
        return this.userTypes();
    }

    @Override
    public void setProjectSubFileComponents(Collection subComponents) {
        this.setTypes(subComponents);
    }

    @Override
    public Iterator originalProjectSubFileComponentNames() {
        return this.userTypeNames.iterator();
    }

    @Override
    public void setOriginalProjectSubFileComponentNames(Collection originalSubComponentNames) {
        this.userTypeNames = originalSubComponentNames;
    }

    @Override
    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(stream.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object child) {
        if (this.types.containsValue(child)) {
            return false;
        }
        return ((Node)child).isDirtyBranch();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassRepository.class);
        XMLCompositeDirectCollectionMapping classpathMapping = new XMLCompositeDirectCollectionMapping();
        classpathMapping.setAttributeName(CLASSPATH_ENTRIES_LIST);
        classpathMapping.setSetMethodName("setClasspathEntriesForTopLink");
        classpathMapping.setGetMethodName("getClasspathEntriesForTopLink");
        classpathMapping.setXPath("classpath-entries/entry/text()");
        descriptor.addMapping((DatabaseMapping)classpathMapping);
        XMLCompositeDirectCollectionMapping userTypeNamesMapping = new XMLCompositeDirectCollectionMapping();
        userTypeNamesMapping.setAttributeName(USER_TYPE_NAMES_COLLECTION);
        userTypeNamesMapping.setSetMethodName("setUserTypeNamesForTopLink");
        userTypeNamesMapping.setGetMethodName("getUserTypeNamesForTopLink");
        userTypeNamesMapping.useCollectionClass(HashSet.class);
        userTypeNamesMapping.setXPath("user-type-names/name/text()");
        descriptor.addMapping((DatabaseMapping)userTypeNamesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUserTypeNamesForTopLink() {
        ArrayList<String> names = new ArrayList<String>(this.userTypes.size());
        Set set = this.userTypes;
        synchronized (set) {
            Iterator stream = this.userTypes.iterator();
            while (stream.hasNext()) {
                names.add(((MWClass)stream.next()).getName());
            }
        }
        return CollectionTools.sort(names, (Comparator)Collator.getInstance());
    }

    private void setUserTypeNamesForTopLink(Collection userTypeNames) {
        this.userTypeNames = userTypeNames;
    }

    private List getClasspathEntriesForTopLink() {
        ArrayList<String> result = new ArrayList<String>(this.classpathEntries.size());
        Iterator stream = this.classpathEntries.iterator();
        while (stream.hasNext()) {
            result.add(((String)stream.next()).replace('\\', '/'));
        }
        return result;
    }

    private void setClasspathEntriesForTopLink(List entries) {
        this.classpathEntries = this.convertToClasspathEntries(entries);
    }

    private List convertToClasspathEntries(List entries) {
        Vector<String> result = new Vector<String>(entries.size());
        Iterator stream = entries.iterator();
        while (stream.hasNext()) {
            result.add(new File((String)stream.next()).getPath());
        }
        return result;
    }

    @Override
    public void postProjectBuild() {
        super.postProjectBuild();
        this.configureImpliedStubInterfaces();
    }

    private void configureImpliedStubInterfaces() {
        Iterator stream = this.types.values().iterator();
        while (stream.hasNext()) {
            ((MWClass)stream.next()).configureImpliedStubInterfaces();
        }
    }

    private boolean typeIsUserSupplied(MWClass type) {
        if (type.isStub()) {
            return false;
        }
        return !MWClassRepository.coreClassNamesContains(type.getName());
    }

    public static Iterator coreClassNames() {
        return MWClassRepository.getCoreClassNames().iterator();
    }

    public static boolean coreClassNamesContains(String typeName) {
        return MWClassRepository.getCoreClassNames().contains(typeName);
    }

    private static synchronized Set getCoreClassNames() {
        if (coreClassNames == null) {
            coreClassNames = MWClassRepository.buildCoreClassNames();
        }
        return coreClassNames;
    }

    private static Set buildCoreClassNames() {
        HashSet result = new HashSet(10000);
        CollectionTools.addAll(result, MWClass.nonReferenceClassNames());
        List<String> locations = MWClassRepository.buildCoreClassLocations();
        Classpath cp = new Classpath(locations);
        cp.addClassNamesTo(result);
        return result;
    }

    private static List<String> buildCoreClassLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        for (int i = 0; i < CORE_KEYS.length; ++i) {
            String classpath = Classpath.locationFor(CORE_KEYS[i]);
            if (locations.contains(classpath)) continue;
            locations.add(classpath);
        }
        return locations;
    }

    public static String coreClassNameIgnoreCase(String typeName) {
        return (String)MWClassRepository.getCoreClassNamesLowerCase().get(typeName.toLowerCase());
    }

    private static synchronized Map getCoreClassNamesLowerCase() {
        if (coreClassNamesLowerCase == null) {
            coreClassNamesLowerCase = MWClassRepository.buildCoreClassNamesLowerCase();
        }
        return coreClassNamesLowerCase;
    }

    private static Map buildCoreClassNamesLowerCase() {
        Set names = MWClassRepository.getCoreClassNames();
        HashMap<String, String> result = new HashMap<String, String>(names.size());
        for (String name : names) {
            result.put(name.toLowerCase(), name);
        }
        return result;
    }

    public boolean isPersistLastRefresh() {
        return this.persistLastRefresh;
    }

    public void setPersistLastRefresh(boolean persistLastRefresh) {
        if (!persistLastRefresh) {
            Iterator userTypeIter = this.userTypes();
            while (userTypeIter.hasNext()) {
                ((MWClass)userTypeIter.next()).markBranchDirty();
            }
        }
        this.persistLastRefresh = persistLastRefresh;
    }
}

