/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class MWZeroArgumentConstructorCodeGenPolicy
extends MWMethodCodeGenPolicy {
    volatile MWDescriptor descriptor;

    public MWZeroArgumentConstructorCodeGenPolicy(MWMethod method, MWDescriptor descriptor, MWClassCodeGenPolicy classCodeGenPolicy) {
        super(method, classCodeGenPolicy);
        this.descriptor = descriptor;
    }

    @Override
    void insertMethodBody(NonreflectiveMethodDefinition methodDef) {
        if (!this.descriptor.getMWClass().getSuperclass().isObject()) {
            methodDef.addLine("super();");
        }
        Collection allInstanceVariables = CollectionTools.collection(this.descriptor.getMWClass().instanceVariables());
        Iterator it = this.descriptor.mappings();
        while (it.hasNext()) {
            MWMapping mapping = (MWMapping)it.next();
            MWClassAttribute attribute = mapping.getInstanceVariable();
            if (!allInstanceVariables.contains(attribute)) continue;
            allInstanceVariables.remove(attribute);
            String initialValue = mapping.initialValue(this.getClassCodeGenPolicy());
            if (initialValue == null || initialValue.equals("")) continue;
            methodDef.addLine("this." + attribute.getName() + " = " + initialValue + ";");
        }
    }
}

