/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWLiteralArgument
extends MWArgument {
    private volatile MWTypeDeclaration type;
    public static final String TYPE_PROPERTY = "type";
    private volatile String value;
    public static final String VALUE_PROPERTY = "value";

    private MWLiteralArgument() {
    }

    MWLiteralArgument(MWBasicExpression expression, MWTypeDeclaration type, String value) {
        super(expression);
        this.type = type;
        this.value = value;
    }

    MWLiteralArgument(MWBasicExpression expression) {
        super(expression);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.type = new MWTypeDeclaration((MWModel)this, this.typeNamed("java.lang.String"));
        this.value = "";
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.type);
    }

    private MWBasicExpression getBasicExpression() {
        return (MWBasicExpression)this.getParent();
    }

    @Override
    public String getType() {
        return "literal";
    }

    @Override
    public void operatorTypeChanged() {
        if (this.getBasicExpression().operatorIsStringType()) {
            this.setType(new MWTypeDeclaration((MWModel)this, this.typeNamed("java.lang.String")));
        }
    }

    public MWTypeDeclaration getLiteralType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == TYPE_PROPERTY) {
            this.setType((MWTypeDeclaration)oldValue);
        } else if (propertyName == VALUE_PROPERTY) {
            this.setValue((String)oldValue);
        }
    }

    public void setType(MWTypeDeclaration type) {
        MWTypeDeclaration oldType = this.getLiteralType();
        this.type = type;
        this.firePropertyChanged(TYPE_PROPERTY, oldType, this.getLiteralType());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, TYPE_PROPERTY, oldType, type);
    }

    public void setValue(String value) {
        Object oldValue = this.getValue();
        this.value = value;
        this.firePropertyChanged(VALUE_PROPERTY, oldValue, this.getValue());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, VALUE_PROPERTY, oldValue, value);
    }

    @Override
    public String displayString() {
        return "\"" + this.getValue() + "\"";
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("type = ");
        sb.append(this.getLiteralType().typeName());
        sb.append(", value = ");
        sb.append(this.getValue());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWLiteralArgument.class);
        descriptor.getInheritancePolicy().setParentClass(MWArgument.class);
        XMLCompositeObjectMapping typeMapping = new XMLCompositeObjectMapping();
        typeMapping.setAttributeName(TYPE_PROPERTY);
        typeMapping.setReferenceClass(MWTypeDeclaration.class);
        typeMapping.setXPath(TYPE_PROPERTY);
        descriptor.addMapping((DatabaseMapping)typeMapping);
        XMLDirectMapping valueMapping = (XMLDirectMapping)descriptor.addDirectMapping(VALUE_PROPERTY, "value/text()");
        valueMapping.setNullValue((Object)"");
        return descriptor;
    }

    @Override
    Expression runtimeExpression(ExpressionBuilder builder) {
        return new ConstantExpression(this.value(), (Expression)builder);
    }

    private Object value() {
        Class<?> nullClass = null;
        try {
            nullClass = Class.forName(this.getLiteralType().typeName());
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        ConversionManager cm = ConversionManager.getDefaultManager();
        try {
            return cm.convertObject((Object)this.value, nullClass);
        }
        catch (ConversionException ce) {
            return null;
        }
    }

    static MWLiteralArgument convertFromRuntime(MWBasicExpression bldrExpression, ConstantExpression runtimeExpression) {
        Object value = runtimeExpression.getValue();
        MWClass type = bldrExpression.typeNamed(value.getClass().getName());
        MWLiteralArgument argument = new MWLiteralArgument(bldrExpression);
        argument.setType(new MWTypeDeclaration((MWModel)argument, type));
        argument.setValue((String)value);
        return argument;
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        Class<?> literalTypeClass = null;
        try {
            literalTypeClass = Class.forName(this.getLiteralType().typeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ConversionManager cm = ConversionManager.getDefaultManager();
        try {
            cm.convertObject((Object)this.value, literalTypeClass);
        }
        catch (ConversionException ce) {
            currentProblems.add(this.buildProblemForConversionException(literalTypeClass));
        }
    }

    private Problem buildProblemForConversionException(Class javaClass) {
        String javaClassName = javaClass.getName();
        String lineNumber = this.getBasicExpression().getIndex();
        String queryName = this.getBasicExpression().getParentQuery().getName();
        if (javaClass == Boolean.class) {
            return this.buildProblem("0263", lineNumber, queryName, javaClassName);
        }
        if (javaClass == Character.class) {
            return this.buildProblem("0264", lineNumber, queryName, javaClassName);
        }
        if (javaClass == Short.class) {
            return this.buildProblem("0265", new Object[]{lineNumber, queryName, javaClassName, NumberFormat.getInstance().format(-32768L), NumberFormat.getInstance().format(32767L)});
        }
        if (javaClass == Byte.class) {
            return this.buildProblem("0262", new Object[]{lineNumber, queryName, javaClassName, NumberFormat.getInstance().format(-128L), NumberFormat.getInstance().format(127L)});
        }
        if (javaClass == Float.class) {
            return this.buildProblem("0265", new Object[]{lineNumber, queryName, javaClassName, NumberFormat.getInstance().format(1.4E-45f), NumberFormat.getInstance().format(3.4028234663852886E38)});
        }
        if (javaClass == Double.class) {
            return this.buildProblem("0265", new Object[]{lineNumber, queryName, javaClassName, NumberFormat.getInstance().format(Double.MIN_VALUE), NumberFormat.getInstance().format(Double.MAX_VALUE)});
        }
        if (javaClass == Integer.class) {
            return this.buildProblem("0265", new Object[]{lineNumber, queryName, javaClassName, NumberFormat.getInstance().format(Integer.MIN_VALUE), NumberFormat.getInstance().format(Integer.MAX_VALUE)});
        }
        if (javaClass == Long.class) {
            return this.buildProblem("0265", new Object[]{lineNumber, queryName, javaClassName, NumberFormat.getInstance().format(Long.MIN_VALUE), NumberFormat.getInstance().format(Long.MAX_VALUE)});
        }
        if (javaClass == String.class) {
            return this.buildProblem("0266", lineNumber, queryName, javaClassName);
        }
        if (javaClass == BigDecimal.class) {
            return this.buildProblem("0267", lineNumber, queryName, javaClassName);
        }
        if (javaClass == BigInteger.class) {
            return this.buildProblem("0268", lineNumber, queryName, javaClassName);
        }
        if (javaClass == Date.class) {
            return this.buildProblem("0269", lineNumber, queryName, javaClassName);
        }
        if (javaClass == Time.class) {
            return this.buildProblem("0211", lineNumber, queryName, javaClassName);
        }
        if (javaClass == Timestamp.class) {
            return this.buildProblem("0212", lineNumber, queryName, javaClassName);
        }
        if (javaClass == java.util.Date.class) {
            return this.buildProblem("0213", lineNumber, queryName, javaClassName);
        }
        if (javaClass == Calendar.class) {
            return this.buildProblem("0214", lineNumber, queryName, javaClassName);
        }
        if (javaClass == byte[].class || javaClass == Byte[].class) {
            return this.buildProblem("0215", lineNumber, queryName, javaClassName);
        }
        if (javaClass == char[].class || javaClass == Character[].class) {
            return this.buildProblem("0216", lineNumber, queryName, javaClassName);
        }
        return this.buildProblem("0217", lineNumber, queryName);
    }
}

