/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;

public class TriStateBoolean
implements Cloneable,
Serializable {
    private final Boolean value;
    private static final long serialVersionUID = 1L;
    public static final TriStateBoolean FALSE = new TriStateBoolean(Boolean.FALSE);
    public static final TriStateBoolean TRUE = new TriStateBoolean(Boolean.TRUE);
    public static final TriStateBoolean UNDEFINED = new TriStateBoolean((Boolean)null);

    public static TriStateBoolean valueOf(Boolean value) {
        return value == null ? UNDEFINED : (value != false ? TRUE : FALSE);
    }

    public static TriStateBoolean valueOf(String value) {
        return TriStateBoolean.valueOf(TriStateBoolean.toBoolean(value));
    }

    public static TriStateBoolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static TriStateBoolean getTriStateBoolean(String name) {
        try {
            return TriStateBoolean.valueOf(System.getProperty(name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return UNDEFINED;
    }

    private static Boolean toBoolean(String value) {
        return value == null || value.equalsIgnoreCase("undefined") ? null : Boolean.valueOf(value);
    }

    public TriStateBoolean(Boolean value) {
        this.value = value == null ? null : (value != false ? Boolean.TRUE : Boolean.FALSE);
    }

    public TriStateBoolean(boolean value) {
        this.value = value;
    }

    public TriStateBoolean(String value) {
        this(TriStateBoolean.toBoolean(value));
    }

    public Boolean getValue() {
        return this.value;
    }

    public boolean booleanValue() {
        if (this.value == null) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    public boolean valueIs(boolean b) {
        return this.value == null ? false : this.value == b;
    }

    public boolean isFalse() {
        return this.valueIs(false);
    }

    public boolean isTrue() {
        return this.valueIs(true);
    }

    public boolean isUndefined() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof TriStateBoolean && this.value == ((TriStateBoolean)o).value;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.value == null ? "undefined" : this.value.toString();
    }
}

