/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import java.math.BigDecimal;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.OracleDBPlatformHelper;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject1;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject2;
import org.eclipse.persistence.testing.tests.sessionbroker.ReadOnlyClassesInSessionBrokerTest;
import org.eclipse.persistence.testing.tests.sessionbroker.SessionBrokerClientQueryTestCase;
import org.eclipse.persistence.testing.tests.sessionbroker.SessionBrokerCustomFunctionTest;
import org.eclipse.persistence.testing.tests.sessionbroker.SessionBrokerPlatformTest;
import org.eclipse.persistence.testing.tests.sessionbroker.VerifyClientBrokerCreationTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class ServerBrokerTestModel
extends TestModel {
    public Session oldSession;
    public static final String QUERY_NAME = "localNumbers";

    public ServerBrokerTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the session broker with the employee demo.");
    }

    public void addQuery1(SessionBroker broker) {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadAllQuery query = new ReadAllQuery(Employee.class, builder);
        Expression exp = builder.get("id").equal(builder.getParameter("ID"));
        query.setSelectionCriteria(exp.and(builder.get("firstName").equal((Object)"Bob")));
        query.addArgument("ID", BigDecimal.class);
        broker.addQuery(QUERY_NAME, (DatabaseQuery)query);
    }

    public void addQuery2(SessionBroker broker) {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadAllQuery query = new ReadAllQuery(PhoneNumber.class, builder);
        query.setSelectionCriteria(builder.get("type").equal((Object)"work"));
        broker.addQuery(QUERY_NAME, (DatabaseQuery)query);
    }

    public void addTests() {
        this.addTest((Test)ServerBrokerTestModel.getReadObjectTestSuite());
        this.addTest((Test)ServerBrokerTestModel.getReadAllTestSuite());
        this.addTest((Test)ServerBrokerTestModel.getSessionBrokerClientQueryTestSuite());
        this.addTest((Test)new SessionBrokerPlatformTest());
        this.addTest((Test)new ReadOnlyClassesInSessionBrokerTest());
        this.addTest((Test)new VerifyClientBrokerCreationTest());
        this.addTest((Test)new SessionBrokerCustomFunctionTest(0));
        this.addTest((Test)new SessionBrokerCustomFunctionTest(1));
        this.addTest((Test)new SessionBrokerCustomFunctionTest(2));
    }

    public SessionBroker buildBroker() {
        this.createTables();
        SessionBroker broker = new SessionBroker();
        this.addQuery1(broker);
        this.addQuery2(broker);
        ServerSession ssession1 = new ServerSession((Login)ServerBrokerTestModel.getLogin1());
        ServerSession ssession2 = new ServerSession((Login)ServerBrokerTestModel.getLogin2());
        ssession1.addDescriptors((Project)new EmployeeProject1());
        ssession2.addDescriptors((Project)new EmployeeProject2());
        broker.registerSession("broker1", (AbstractSession)ssession1);
        broker.registerSession("broker2", (AbstractSession)ssession2);
        broker.setLog(this.oldSession.getLog());
        broker.setLogLevel(this.oldSession.getLogLevel());
        broker.login();
        ((ManyToManyMapping)ssession1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("projects")).setSessionName("broker2");
        ((OneToOneMapping)ssession1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("address")).setShouldVerifyDelete(false);
        SessionBroker clientBroker = broker.acquireClientSessionBroker();
        new EmployeeSystem().populate((DatabaseSession)clientBroker);
        return clientBroker;
    }

    public void createTables() {
        SessionBroker broker = new SessionBroker();
        DatabaseSessionImpl session1 = new DatabaseSessionImpl((Login)ServerBrokerTestModel.getLogin1());
        DatabaseSessionImpl session2 = new DatabaseSessionImpl((Login)ServerBrokerTestModel.getLogin2());
        session1.addDescriptors((Project)new EmployeeProject1());
        session2.addDescriptors((Project)new EmployeeProject2());
        broker.registerSession("broker1", (Session)session1);
        broker.registerSession("broker2", (Session)session2);
        broker.setLog(this.oldSession.getLog());
        broker.setLogLevel(this.oldSession.getLogLevel());
        broker.login();
        EmployeeTableCreator tables = new EmployeeTableCreator();
        tables.replaceTables((DatabaseSession)session1);
        tables.replaceTables((DatabaseSession)session2);
        tables.dropConstraints((DatabaseSession)session1);
        tables.dropConstraints((DatabaseSession)session2);
        new SchemaManager((DatabaseSession)session1).createSequences();
        new SchemaManager((DatabaseSession)session2).createSequences();
        broker.logout();
    }

    public static DatabaseLogin getLogin1() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL("ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA7");
        login.setPassword("password");
        login.useNativeSequencing();
        login.getDefaultSequence().setPreallocationSize(1);
        return login;
    }

    public static DatabaseLogin getLogin2() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL("ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA8");
        login.setPassword("password");
        login.useNativeSequencing();
        login.getDefaultSequence().setPreallocationSize(1);
        return login;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerReadAllTestSuite");
        suite.setDescription("This suite tests read all sql.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(org.eclipse.persistence.testing.models.employee.domain.Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerReadObjectTestSuite");
        suite.setDescription("This suite test read sql.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(LargeProject.class, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(SmallProject.class, "0004")));
        return suite;
    }

    public static TestSuite getSessionBrokerClientQueryTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("SessionBrokerClientQueryTestSuite");
        suite.setDescription("This suite tests queries.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new SessionBrokerClientQueryTestCase());
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            if (this.getExecutor().getSession() instanceof SessionBroker) {
                ((ClientSession)((SessionBroker)this.getExecutor().getSession()).getSessionForName("broker1")).getParent().logout();
                ((ClientSession)((SessionBroker)this.getExecutor().getSession()).getSessionForName("broker2")).getParent().logout();
            }
        }
        finally {
            this.getExecutor().setSession(this.oldSession);
        }
    }

    public void setup() {
        this.oldSession = this.getSession();
        this.getExecutor().setSession((Session)this.buildBroker());
    }
}

