/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseTypeBase;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitable;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class ProcedureType
extends CompositeDatabaseTypeBase
implements CompositeDatabaseType,
DatabaseTypeVisitable {
    protected String catalogName;
    protected String procedureName;
    protected String schema;
    protected int overload;
    protected PLSQLPackageType parentType = null;
    protected List<ArgumentType> arguments = new ArrayList<ArgumentType>();

    public ProcedureType(String procedureName) {
        super(null);
        this.setProcedureName(procedureName);
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
        this.typeName = "PROCEDURE " + procedureName;
    }

    public String getSchema() {
        if (this.parentType != null && this.schema == null) {
            this.schema = this.parentType.getSchema();
        }
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public int getOverload() {
        return this.overload;
    }

    public void setOverload(int overload) {
        this.overload = overload;
    }

    public PLSQLPackageType getParentType() {
        return this.parentType;
    }

    public void setParentType(PLSQLPackageType parentType) {
        this.parentType = parentType;
    }

    @Override
    public DatabaseType getEnclosedType() {
        return null;
    }

    @Override
    public void setEnclosedType(DatabaseType enclosedType) {
    }

    public List<ArgumentType> getArguments() {
        return this.arguments;
    }

    public void addArgument(ArgumentType arg) {
        this.arguments.add(arg);
    }

    @Override
    public boolean isResolved() {
        for (ArgumentType argType : this.arguments) {
            if (argType.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isProcedureType() {
        return true;
    }

    @Override
    public boolean isFunctionType() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PROCEDURE ");
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(".");
        }
        sb.append(this.procedureName);
        sb.append("(");
        int i = 0;
        while (i < this.arguments.size()) {
            ArgumentType arg = this.arguments.get(i);
            sb.append(arg.toString());
            if (++i >= this.arguments.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }
}

