/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.LegacyProjectReadCallback;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsio.legacy.LegacyIOFacade;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.DefaultSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SimpleSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassRepositoryFactory;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;
import org.w3c.dom.Document;

class ProjectReader {
    private ProjectIOManager ioManager;
    private File file;
    private Preferences preferences;
    private FileNotFoundListener listener;
    private LegacyProjectReadCallback legacyProjectReadCallback;
    private Document document;
    private String schemaVersion;
    private static final String PROJECT_ROOT_ELEMENT_NAME_4_X = "BldrProject";
    private static final String SCHEMA_VERSION_ELEMENT_NAME_5_0 = "schemaVersion";
    private static final String SCHEMA_VERSION_ELEMENT_NAME_4_X = "version";
    private static final String SCHEMA_VERSION_7_0 = "7.0";
    private static final String SCHEMA_VERSION_6_0 = "6.0";
    private static final String SCHEMA_VERSION_5_X = "5";
    private static final String SCHEMA_VERSION_4_5 = "4.5";
    private static final String PRODUCT_VERSION_4_6 = "4.6";
    private static final String PRODUCT_VERSION_9_0_3 = "9.0.3";

    ProjectReader(ProjectIOManager ioManager, File file, Preferences preferences, FileNotFoundListener listener, LegacyProjectReadCallback legacyProjectReadCallback) {
        this.ioManager = ioManager;
        this.file = file;
        this.preferences = preferences;
        this.listener = listener;
        this.legacyProjectReadCallback = legacyProjectReadCallback;
    }

    MWProject read() {
        this.document = XMLTools.parse(this.file);
        this.schemaVersion = this.schemaVersion();
        if (this.schemaVersion.equals(SCHEMA_VERSION_7_0)) {
            return this.readProject();
        }
        return this.readLegacyProject();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.file);
    }

    private String schemaVersion() {
        org.w3c.dom.Node rootNode = this.rootNode();
        org.w3c.dom.Node schemaVersionNode = XMLTools.child(rootNode, "schema-version");
        if (schemaVersionNode == null) {
            schemaVersionNode = XMLTools.child(rootNode, SCHEMA_VERSION_ELEMENT_NAME_5_0);
        }
        if (schemaVersionNode == null) {
            schemaVersionNode = XMLTools.child(rootNode, SCHEMA_VERSION_ELEMENT_NAME_4_X);
        }
        if (schemaVersionNode == null) {
            throw new IllegalArgumentException();
        }
        return XMLTools.textContent(schemaVersionNode);
    }

    private org.w3c.dom.Node rootNode() {
        org.w3c.dom.Node rootNode = XMLTools.child(this.document, "project");
        if (rootNode == null) {
            rootNode = XMLTools.child(this.document, PROJECT_ROOT_ELEMENT_NAME_4_X);
        }
        if (rootNode == null) {
            throw new IllegalArgumentException();
        }
        return rootNode;
    }

    private MWProject readProject() {
        MWProject project;
        try {
            project = (MWProject)this.readObject(this.file);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ClassTools.invokeMethod((Object)project, "setSaveDirectoryForIOManager", File.class, this.baseDirectory());
        this.injectSPIManager(project, new DefaultSPIManager(this.preferences, project.getName()));
        SubComponentReader[] subComponentReaders = this.buildSubComponentReaders(project);
        for (int i = 0; i < subComponentReaders.length; ++i) {
            subComponentReaders[i].read();
        }
        project.postProjectBuild();
        return project;
    }

    private SubComponentReader[] buildSubComponentReaders(MWProject project) {
        return new SubComponentReader[]{new SubComponentReader(project.getClassRepository()), new SubComponentReader(project.getMetaDataSubComponentContainer()), new SubComponentReader(project.getDescriptorRepository())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readObject(File xmlFile) throws IOException {
        Object object = null;
        try (InputStream stream = null;){
            stream = new BufferedInputStream(new FileInputStream(xmlFile));
            object = this.ioManager.getUnmarshaller().unmarshal(stream);
        }
        return object;
    }

    File baseDirectory() {
        return this.file.getParentFile();
    }

    String defaultFileNameExtension() {
        return this.ioManager.defaultFileNameExtension();
    }

    String subDirectoryNameFor(Object container) {
        return this.ioManager.subDirectoryNameFor(container);
    }

    void fireFileNotFound(File missingFile) {
        this.ioManager.fireFileNotFound(this.listener, missingFile);
    }

    private void injectSPIManager(MWProject project, SPIManager spiManager) {
        ClassTools.invokeMethod((Object)project, "setSPIManagerForIOManager", SPIManager.class, spiManager);
    }

    private MWProject readLegacyProject() {
        if (!this.schemaVersion.startsWith(SCHEMA_VERSION_6_0)) {
            throw new IllegalStateException(this.schemaVersion);
        }
        this.legacyProjectReadCallback.checkLegacyRead(this.schemaVersion);
        MWProject project = LegacyIOFacade.read60Project(this.file, this.preferences);
        project.markEntireBranchDirty();
        project.setIsLegacyProject(true);
        return project;
    }

    private SPIManager buildSimpleSPIManager() {
        SimpleSPIManager mgr = new SimpleSPIManager();
        mgr.setExternalClassRepositoryFactory(CFExternalClassRepositoryFactory.instance());
        return mgr;
    }

    private class SubComponentReader {
        private ProjectSubFileComponentContainer container;

        SubComponentReader(ProjectSubFileComponentContainer container) {
            this.container = container;
        }

        void read() {
            String ext = ProjectReader.this.defaultFileNameExtension();
            String subDirectoryName = ProjectReader.this.subDirectoryNameFor(this.container);
            File subDirectory = new File(this.baseDirectory(), subDirectoryName);
            Set names = CollectionTools.set(this.container.originalProjectSubFileComponentNames());
            Vector<MWModel> subComponents = new Vector<MWModel>(names.size());
            Iterator stream = names.iterator();
            while (stream.hasNext()) {
                String name = (String)stream.next();
                String fileName = FileTools.FILE_NAME_ENCODER.encode(name);
                File subFile = new File(subDirectory, fileName + ext);
                MWModel subComponent = (MWModel)this.readObject(subFile);
                if (subComponent == null) {
                    ProjectReader.this.fireFileNotFound(subFile);
                    stream.remove();
                    continue;
                }
                subComponent.setParent((Node)((Object)this.container));
                subComponents.add(subComponent);
            }
            this.container.setProjectSubFileComponents(subComponents);
        }

        private File baseDirectory() {
            return ProjectReader.this.baseDirectory();
        }

        private Object readObject(File xmlFile) {
            try {
                return ProjectReader.this.readObject(xmlFile);
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

