/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWJoinFetchableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMappingHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWAbstractReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractTableReferenceMapping
extends MWAbstractReferenceMapping
implements MWTableReferenceMapping,
MWIndirectableMapping,
MWJoinFetchableMapping {
    private MWReferenceHandle referenceHandle;
    private volatile boolean maintainsBidirectionalRelationship;
    public static final String MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY = "maintainsBidirectionalRelationship";
    private MWMappingHandle relationshipPartnerMappingHandle;
    public static final String RELATIONSHIP_PARTNER_MAPPING_PROPERTY = "relationshipPartnerMapping";
    private volatile MWJoinFetchableMapping.JoinFetchOption joinFetchOption;
    private static TopLinkOptionSet joinFetchOptions;
    private volatile boolean batchReading;

    protected MWAbstractTableReferenceMapping() {
    }

    protected MWAbstractTableReferenceMapping(MWRelationalClassDescriptor descriptor, MWClassAttribute attribute, String mappingName) {
        super(descriptor, attribute, mappingName);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.referenceHandle = new MWReferenceHandle(this, this.buildReferenceScrubber());
        this.relationshipPartnerMappingHandle = new MWMappingHandle(this, this.buildRelationshipPartnerMappingScrubber());
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
    }

    @Override
    public MWJoinFetchableMapping.JoinFetchOption getJoinFetchOption() {
        if (this.joinFetchOption == null) {
            this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
        }
        return this.joinFetchOption;
    }

    @Override
    public void setJoinFetchOption(MWJoinFetchableMapping.JoinFetchOption newJoinFetchOption) {
        MWJoinFetchableMapping.JoinFetchOption old = this.joinFetchOption;
        this.joinFetchOption = newJoinFetchOption;
        this.firePropertyChanged("joinFetchOption", old, this.joinFetchOption);
    }

    @Override
    public void setJoinFetchOption(String joinFetchOptions) {
        this.setJoinFetchOption((MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption(joinFetchOptions));
    }

    @Override
    public MWReference getReference() {
        return this.referenceHandle.getReference();
    }

    @Override
    public void setReference(MWReference newValue) {
        MWReference oldValue = this.getReference();
        this.referenceHandle.setReference(newValue);
        this.firePropertyChanged("reference", oldValue, newValue);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    @Override
    public boolean maintainsBidirectionalRelationship() {
        return this.maintainsBidirectionalRelationship;
    }

    public void setMaintainsBidirectionalRelationship(boolean newBoolean) {
        boolean oldBoolean = this.maintainsBidirectionalRelationship;
        this.maintainsBidirectionalRelationship = newBoolean;
        this.firePropertyChanged(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, oldBoolean, newBoolean);
        if (!newBoolean) {
            this.setRelationshipPartnerMapping(null);
        }
    }

    @Override
    public MWMapping getRelationshipPartnerMapping() {
        return this.relationshipPartnerMappingHandle.getMapping();
    }

    public Collection getRelationshipPartnerMappingChoices() {
        if (this.getReferenceDescriptor() == null) {
            return Collections.EMPTY_SET;
        }
        Collection choices = CollectionTools.collection(this.getReferenceDescriptor().mappings());
        choices.remove(this);
        return choices;
    }

    public void setRelationshipPartnerMapping(MWMapping newValue) {
        MWMapping oldValue = this.getRelationshipPartnerMapping();
        this.relationshipPartnerMappingHandle.setMapping(newValue);
        this.firePropertyChanged(RELATIONSHIP_PARTNER_MAPPING_PROPERTY, oldValue, newValue);
    }

    @Override
    public void setReferenceDescriptor(MWDescriptor newReferenceDescriptor) {
        if (this.getReferenceDescriptor() != newReferenceDescriptor) {
            this.setRelationshipPartnerMapping(null);
        }
        super.setReferenceDescriptor(newReferenceDescriptor);
    }

    @Override
    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor descriptor) {
        return ((MWRelationalDescriptor)((Object)descriptor)).isTableDescriptor();
    }

    @Override
    public boolean usesBatchReading() {
        return this.batchReading;
    }

    @Override
    public void setUsesBatchReading(boolean newValue) {
        boolean oldValue = this.batchReading;
        this.batchReading = newValue;
        this.firePropertyChanged("usesBatchReading", oldValue, newValue);
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    @Override
    public void automap() {
        super.automap();
        this.automapTableReference();
        this.automapIndirection();
    }

    protected void automapTableReference() {
        if (this.getReference() != null) {
            return;
        }
        MWRelationalDescriptor referenceDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (referenceDescriptor == null) {
            return;
        }
        Set candidateReferences = this.buildCandidateReferences();
        if (candidateReferences.isEmpty()) {
            return;
        }
        Set sourceTables = CollectionTools.set(this.getParentRelationalDescriptor().associatedTables());
        Set targetTables = CollectionTools.set(referenceDescriptor.associatedTables());
        for (MWReference reference : candidateReferences) {
            MWTable sourceTable = reference.getSourceTable();
            MWTable targetTable = reference.getTargetTable();
            if ((!sourceTables.contains(sourceTable) || !targetTables.contains(targetTable)) && (!sourceTables.contains(targetTable) || !targetTables.contains(sourceTable))) continue;
            this.setReference(reference);
            break;
        }
    }

    protected abstract Set buildCandidateReferences();

    protected Set buildCandidateTargetReferences() {
        MWRelationalDescriptor referenceDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (referenceDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> candidateReferences = new HashSet<MWReference>();
        Set targetTables = CollectionTools.set(this.getParentRelationalDescriptor().candidateTablesIncludingInherited());
        Iterator sourceTables = referenceDescriptor.associatedTablesIncludingInherited();
        while (sourceTables.hasNext()) {
            MWTable sourceTable = (MWTable)sourceTables.next();
            Iterator references = sourceTable.references();
            while (references.hasNext()) {
                MWReference refererence = (MWReference)references.next();
                if (!targetTables.contains(refererence.getTargetTable())) continue;
                candidateReferences.add(refererence);
            }
        }
        return candidateReferences;
    }

    protected Set buildCandidateSourceReferences() {
        MWRelationalDescriptor referenceDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (referenceDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> candidateReferences = new HashSet<MWReference>();
        Set targetTables = CollectionTools.set(referenceDescriptor.associatedTables());
        Iterator sourceTables = this.getParentRelationalDescriptor().candidateTables();
        while (sourceTables.hasNext()) {
            MWTable sourceTable = (MWTable)sourceTables.next();
            Iterator references = sourceTable.references();
            while (references.hasNext()) {
                MWReference reference = (MWReference)references.next();
                if (!targetTables.contains(reference.getTargetTable())) continue;
                candidateReferences.add(reference);
            }
        }
        return candidateReferences;
    }

    protected void automapIndirection() {
        if (this.getInstanceVariable().isValueHolder()) {
            this.setUseValueHolderIndirection();
        }
    }

    @Override
    public Iterator candidateReferences() {
        return this.buildCandidateReferences().iterator();
    }

    @Override
    public boolean referenceIsCandidate(MWReference reference) {
        return this.buildCandidateReferences().contains(reference);
    }

    @Override
    public boolean isTraversableForBatchReadAttribute() {
        return true;
    }

    @Override
    public boolean isValidForBatchReadAttribute() {
        return true;
    }

    @Override
    public boolean isTraversableForJoinedAttribute() {
        return true;
    }

    @Override
    public boolean isValidForJoinedAttribute() {
        return true;
    }

    protected abstract boolean fieldIsWritten(MWColumnPair var1);

    @Override
    public boolean isTableReferenceMapping() {
        return true;
    }

    public boolean isManyToManyMapping() {
        return false;
    }

    public boolean isOneToManyMapping() {
        return false;
    }

    public boolean isQueryable() {
        return true;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public boolean allowsOuterJoin() {
        return this.allowsChildren();
    }

    @Override
    public boolean isLeaf(Filter queryableFilter) {
        return this.subQueryableElements(queryableFilter).size() == 0;
    }

    @Override
    public List subQueryableElements(Filter queryableFilter) {
        List subQueryableElements = new ArrayList();
        if (this.getReferenceDescriptor() != null) {
            subQueryableElements = ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).getQueryables(queryableFilter);
            Collections.sort(subQueryableElements, DEFAULT_COMPARATOR);
        }
        return subQueryableElements;
    }

    @Override
    public MWQueryable subQueryableElementAt(int index, Filter queryableFilter) {
        return (MWQueryable)this.subQueryableElements(queryableFilter).get(index);
    }

    @Override
    public boolean isTraversableForQueryExpression() {
        return true;
    }

    @Override
    public boolean isValidForQueryExpression() {
        return true;
    }

    @Override
    public boolean isTraversableForReportQueryAttribute() {
        return true;
    }

    @Override
    public void initializeFromMWAbstractTableReferenceMapping(MWAbstractTableReferenceMapping oldMapping) {
        super.initializeFromMWAbstractTableReferenceMapping(oldMapping);
        this.setReference(oldMapping.getReference());
        this.setMaintainsBidirectionalRelationship(oldMapping.maintainsBidirectionalRelationship());
        this.setRelationshipPartnerMapping(oldMapping.getRelationshipPartnerMapping());
        this.setUsesBatchReading(oldMapping.usesBatchReading());
    }

    @Override
    public void initializeFromMWRelationalDirectContainerMapping(MWRelationalDirectContainerMapping oldMapping) {
        super.initializeFromMWRelationalDirectContainerMapping(oldMapping);
        this.setReference(oldMapping.getReference());
        this.setUsesBatchReading(oldMapping.usesBatchReading());
    }

    @Override
    public boolean isValidRelationshipPartner() {
        return true;
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.referenceHandle);
        children.add(this.relationshipPartnerMappingHandle);
    }

    private MWHandle.NodeReferenceScrubber buildRelationshipPartnerMappingScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAbstractTableReferenceMapping.this.setRelationshipPartnerMapping(null);
            }

            public String toString() {
                return "MWAbstractTableReferenceMapping.buildRelationshipPartnerMappingScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAbstractTableReferenceMapping.this.setReference(null);
            }

            public String toString() {
                return "MWAbstractTableReferenceMapping.buildReferenceScrubber()";
            }
        };
    }

    @Override
    public void descriptorUnmapped(Collection mappings) {
        super.descriptorUnmapped(mappings);
        if (this.getRelationshipPartnerMapping() != null && mappings.contains(this.getRelationshipPartnerMapping())) {
            this.setRelationshipPartnerMapping(null);
        }
    }

    @Override
    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
        super.mappingReplaced(oldMapping, newMapping);
        if (oldMapping == this.getRelationshipPartnerMapping()) {
            this.setRelationshipPartnerMapping(newMapping);
        }
    }

    public boolean sourceReferenceFieldsAreFromSourceDescriptorTables() {
        return false;
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkReference(newProblems);
        this.addInvalidRelationshipPartnerProblemTo(newProblems);
        this.addHasNonMutualRelationshipPartnerProblemTo(newProblems);
    }

    @Override
    protected String referenceDescriptorInvalidProblemString() {
        return "0467";
    }

    private void checkReference(List newProblems) {
        if (this.getReference() == null) {
            newProblems.add(this.buildProblem("0460"));
            return;
        }
        if (!this.referenceIsCandidate(this.getReference())) {
            newProblems.add(this.buildProblem("0461"));
        }
    }

    private void addInvalidRelationshipPartnerProblemTo(List newProblems) {
        if (!this.maintainsBidirectionalRelationship()) {
            return;
        }
        if (this.getRelationshipPartnerMapping() == null) {
            newProblems.add(this.buildProblem("0464"));
        } else if (!this.getRelationshipPartnerMapping().isValidRelationshipPartner()) {
            newProblems.add(this.buildProblem("0465"));
        }
    }

    private void addHasNonMutualRelationshipPartnerProblemTo(List newProblems) {
        MWMapping relationshipPartnerMapping = this.getRelationshipPartnerMapping();
        if (this.maintainsBidirectionalRelationship() && relationshipPartnerMapping != null && (!relationshipPartnerMapping.maintainsBidirectionalRelationship() || relationshipPartnerMapping.getRelationshipPartnerMapping() != this)) {
            newProblems.add(this.buildProblem("0466"));
        }
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        ForeignReferenceMapping runtimeMapping = (ForeignReferenceMapping)super.runtimeMapping();
        if (this.getReference() == null) {
            return runtimeMapping;
        }
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getMWClass() != null) {
            runtimeMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        if (this.maintainsBidirectionalRelationship() && this.getRelationshipPartnerMapping() != null) {
            runtimeMapping.setRelationshipPartnerAttributeName(this.getRelationshipPartnerMapping().getInstanceVariable().getName());
        }
        this.joinFetchOption.setMWOptionOnTopLinkObject(runtimeMapping);
        runtimeMapping.setUsesBatchReading(this.usesBatchReading());
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractTableReferenceMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLDirectMapping mbdrMapping = (XMLDirectMapping)descriptor.addDirectMapping(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, "maintains-bidirectional-relationship/text()");
        mbdrMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping relationshipPartnerMapping = new XMLCompositeObjectMapping();
        relationshipPartnerMapping.setAttributeName("relationshipPartnerMappingHandle");
        relationshipPartnerMapping.setGetMethodName("getRelationshipPartnerMappingHandleForTopLink");
        relationshipPartnerMapping.setSetMethodName("setRelationshipPartnerMappingHandleForTopLink");
        relationshipPartnerMapping.setReferenceClass(MWMappingHandle.class);
        relationshipPartnerMapping.setXPath("relationship-partner-mapping-handle");
        descriptor.addMapping((DatabaseMapping)relationshipPartnerMapping);
        XMLCompositeObjectMapping referenceHandleMapping = new XMLCompositeObjectMapping();
        referenceHandleMapping.setAttributeName("referenceHandle");
        referenceHandleMapping.setGetMethodName("getReferenceHandleForTopLink");
        referenceHandleMapping.setSetMethodName("setReferenceHandleForTopLink");
        referenceHandleMapping.setReferenceClass(MWReferenceHandle.class);
        referenceHandleMapping.setXPath("reference-handle");
        descriptor.addMapping((DatabaseMapping)referenceHandleMapping);
        ObjectTypeConverter joinFetchingConverter = new ObjectTypeConverter();
        MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().addConversionValuesForTopLinkTo(joinFetchingConverter);
        XMLDirectMapping joinFetchingMapping = new XMLDirectMapping();
        joinFetchingMapping.setAttributeName("joinFetchOption");
        joinFetchingMapping.setXPath("join-fetch-option/text()");
        joinFetchingMapping.setNullValue((Object)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE"));
        joinFetchingMapping.setConverter((Converter)joinFetchingConverter);
        descriptor.addMapping((DatabaseMapping)joinFetchingMapping);
        XMLDirectMapping batchReadingMapping = (XMLDirectMapping)descriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        batchReadingMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private MWMappingHandle getRelationshipPartnerMappingHandleForTopLink() {
        return this.relationshipPartnerMappingHandle.getMapping() == null ? null : this.relationshipPartnerMappingHandle;
    }

    private void setRelationshipPartnerMappingHandleForTopLink(MWMappingHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildRelationshipPartnerMappingScrubber();
        this.relationshipPartnerMappingHandle = handle == null ? new MWMappingHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWReferenceHandle getReferenceHandleForTopLink() {
        return this.referenceHandle.getReference() == null ? null : this.referenceHandle;
    }

    private void setReferenceHandleForTopLink(MWReferenceHandle referenceHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReferenceScrubber();
        this.referenceHandle = referenceHandle == null ? new MWReferenceHandle(this, scrubber) : referenceHandle.setScrubber(scrubber);
    }

    protected void setJoinFetchingForToplink(String newJoinFetching) {
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption(newJoinFetching);
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWAbstractTableReferenceMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLDirectMapping mbdrMapping = (XMLDirectMapping)descriptor.addDirectMapping(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, "maintains-bidirectional-relationship/text()");
        mbdrMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping relationshipPartnerMapping = new XMLCompositeObjectMapping();
        relationshipPartnerMapping.setAttributeName("relationshipPartnerMappingHandle");
        relationshipPartnerMapping.setGetMethodName("getRelationshipPartnerMappingHandleForTopLink");
        relationshipPartnerMapping.setSetMethodName("setRelationshipPartnerMappingHandleForTopLink");
        relationshipPartnerMapping.setReferenceClass(MWMappingHandle.class);
        relationshipPartnerMapping.setXPath("relationship-partner-mapping-handle");
        descriptor.addMapping((DatabaseMapping)relationshipPartnerMapping);
        XMLCompositeObjectMapping referenceHandleMapping = new XMLCompositeObjectMapping();
        referenceHandleMapping.setAttributeName("referenceHandle");
        referenceHandleMapping.setGetMethodName("getReferenceHandleForTopLink");
        referenceHandleMapping.setSetMethodName("setReferenceHandleForTopLink");
        referenceHandleMapping.setReferenceClass(MWReferenceHandle.class);
        referenceHandleMapping.setXPath("reference-handle");
        descriptor.addMapping((DatabaseMapping)referenceHandleMapping);
        XMLDirectMapping batchReadingMapping = (XMLDirectMapping)descriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        batchReadingMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    @Override
    protected void legacy60PostBuild(DescriptorEvent event) {
        super.legacy60PostBuild(event);
        if (this.joinFetchOption == null) {
            this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
        }
    }

    @Override
    public TopLinkOptionSet joinFetchOptions() {
        if (joinFetchOptions == null) {
            joinFetchOptions = MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions();
        }
        return joinFetchOptions;
    }

    protected static class ColumnPairAggregateRuntimeFieldNameGenerator
    implements AggregateRuntimeFieldNameGenerator {
        MWAbstractTableReferenceMapping mapping;
        private MWColumnPair columnPair;
        private boolean source;

        ColumnPairAggregateRuntimeFieldNameGenerator(MWAbstractTableReferenceMapping mapping, MWColumnPair columnPair, boolean source) {
            this.mapping = mapping;
            this.columnPair = columnPair;
            this.source = source;
        }

        @Override
        public boolean fieldIsWritten() {
            return this.mapping.fieldIsWritten(this.columnPair);
        }

        @Override
        public String fieldNameForRuntime() {
            MWColumn field = this.source ? this.columnPair.getSourceColumn() : this.columnPair.getTargetColumn();
            return field.getName() + "_IN_REFERENCE_" + this.mapping.getReference().getName();
        }

        @Override
        public AggregateFieldDescription fullFieldDescription() {
            final MWColumn column = this.source ? this.columnPair.getSourceColumn() : this.columnPair.getTargetColumn();
            return new AggregateFieldDescription(){

                @Override
                public String getMessageKey() {
                    return "AGGREGATE_FIELD_DESCRIPTION_FOR_REFERENCE";
                }

                @Override
                public Object[] getMessageArguments() {
                    return new Object[]{column.getName(), ColumnPairAggregateRuntimeFieldNameGenerator.this.mapping.getReference().getName()};
                }
            };
        }

        @Override
        public MWDescriptor owningDescriptor() {
            throw new UnsupportedOperationException();
        }
    }
}

