/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LineNumber {
    private short startPC;
    private short lineNumber;

    LineNumber(ClassFileDataInputStream stream) throws IOException {
        this.initialize(stream);
    }

    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.startPC = stream.readU2();
        this.lineNumber = stream.readU2();
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        writer.print("line number: ");
        writer.print(this.lineNumber);
        writer.print(" PC start: ");
        writer.println(this.startPC);
    }

    public short getStartPC() {
        return this.startPC;
    }

    public short getLineNumber() {
        return this.lineNumber;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.lineNumber + ':' + this.startPC + ')';
    }
}

