/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.uitools.RecentFilesManager;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

public final class PreferencesRecentFilesManager
extends AbstractModel
implements RecentFilesManager {
    private Preferences recentFilesNode;
    private PreferenceChangeListener recentFilesListener;
    private List recentFiles;
    private Preferences maxSizeNode;
    String maxSizeKeyName;
    private PreferenceChangeListener maxSizeListener;
    private int maxSize;

    public PreferencesRecentFilesManager(Preferences recentFilesNode, Preferences maxSizeNode, String maxSizeKeyName) {
        this.initialize(recentFilesNode, maxSizeNode, maxSizeKeyName);
    }

    protected void initialize() {
        super.initialize();
        this.recentFilesListener = this.buildRecentFilesListener();
        this.maxSizeListener = this.buildMaxSizeListener();
    }

    private PreferenceChangeListener buildRecentFilesListener() {
        return new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                PreferencesRecentFilesManager.this.recentFilesChanged(evt.getKey(), evt.getNewValue());
            }

            public String toString() {
                return "recent files listener";
            }
        };
    }

    private PreferenceChangeListener buildMaxSizeListener() {
        return new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey().equals(PreferencesRecentFilesManager.this.maxSizeKeyName)) {
                    PreferencesRecentFilesManager.this.maxSizeChanged();
                }
            }

            public String toString() {
                return "max size listener";
            }
        };
    }

    private void initialize(Preferences recentFilesPreferences, Preferences maxSizePreferences, String maxSizePrefKeyName) {
        this.recentFilesNode = recentFilesPreferences;
        recentFilesPreferences.addPreferenceChangeListener(this.recentFilesListener);
        this.maxSizeNode = maxSizePreferences;
        this.maxSizeKeyName = maxSizePrefKeyName;
        maxSizePreferences.addPreferenceChangeListener(this.maxSizeListener);
        this.maxSize = this.buildMaxSize();
        this.checkMaxSize(this.maxSize);
        this.recentFiles = this.buildRecentFiles();
    }

    @Override
    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized void setMaxSize(int maxSize) {
        if (this.maxSize == maxSize) {
            return;
        }
        this.checkMaxSize(maxSize);
        this.maxSize = maxSize;
        List oldRecentFiles = this.recentFiles;
        this.recentFiles = this.buildRecentFiles();
        if (!oldRecentFiles.equals(this.recentFiles)) {
            this.fireStateChanged();
        }
        this.maxSizeNode.putInt(this.maxSizeKeyName, maxSize);
    }

    @Override
    public synchronized File[] getRecentFiles() {
        return this.recentFiles.toArray(new File[this.recentFiles.size()]);
    }

    @Override
    public synchronized void setMostRecentFile(File file) {
        int index = this.recentFiles.indexOf(file);
        if (index == 0) {
            return;
        }
        if (index == -1) {
            this.recentFiles.add(0, file);
            if (this.recentFiles.size() > this.maxSize) {
                while (this.recentFiles.size() > this.maxSize) {
                    this.recentFiles.remove(this.recentFiles.size() - 1);
                }
            }
            this.fireStateChanged();
            this.replacePreferences(this.recentFiles);
        } else {
            this.recentFiles.remove(index);
            this.recentFiles.add(0, file);
            this.fireStateChanged();
            this.replacePreferences(this.recentFiles.subList(0, index + 1));
        }
    }

    @Override
    public synchronized void removeRecentFile(File file) {
        int index = this.recentFiles.indexOf(file);
        if (index == -1) {
            return;
        }
        this.recentFiles.remove(index);
        this.fireStateChanged();
        this.recentFilesNode.remove(Integer.toString(this.recentFiles.size() + 1));
        this.replacePreferences(this.recentFiles);
    }

    private int buildMaxSize() {
        return this.maxSizeNode.getInt(this.maxSizeKeyName, 4);
    }

    private void checkMaxSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("the maximum size must not be negative");
        }
        if (size > 9) {
            throw new IllegalArgumentException("the maximum size must be less than 9");
        }
    }

    private List buildRecentFiles() {
        ArrayList<File> result = new ArrayList<File>(this.maxSize);
        int count = 1;
        String fileName = this.recentFilesNode.get(Integer.toString(count), null);
        while (fileName != null && count <= this.maxSize) {
            result.add(new File(fileName));
            fileName = this.recentFilesNode.get(Integer.toString(++count), null);
        }
        return result;
    }

    private void replacePreferences(List files) {
        for (int i = 0; i < files.size(); ++i) {
            this.recentFilesNode.put(Integer.toString(i + 1), ((File)files.get(i)).getPath());
        }
    }

    synchronized void recentFilesChanged(String key, String newValue) {
        int count = 0;
        try {
            count = Integer.parseInt(key);
        }
        catch (NumberFormatException ex) {
            return;
        }
        if (!Integer.toString(count).equals(key)) {
            return;
        }
        if (count < 1 || count > this.recentFiles.size() + 1 || count > this.maxSize) {
            return;
        }
        int index = count - 1;
        if (newValue == null) {
            while (this.recentFiles.size() > index) {
                this.recentFiles.remove(this.recentFiles.size() - 1);
            }
            this.fireStateChanged();
            return;
        }
        File newFile = new File(newValue);
        if (index == this.recentFiles.size()) {
            this.recentFiles.add(newFile);
            this.fireStateChanged();
            return;
        }
        if (newFile.equals(this.recentFiles.get(index))) {
            return;
        }
        this.recentFiles.set(index, newFile);
        this.fireStateChanged();
    }

    synchronized void maxSizeChanged() {
        int newMaxSize = this.buildMaxSize();
        if (this.maxSize == newMaxSize) {
            return;
        }
        this.checkMaxSize(newMaxSize);
        this.maxSize = newMaxSize;
        List oldRecentFiles = this.recentFiles;
        this.recentFiles = this.buildRecentFiles();
        if (!oldRecentFiles.equals(this.recentFiles)) {
            this.fireStateChanged();
        }
    }
}

