/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public abstract class CollectionPropertyValueModelAdapter
extends AbstractModel
implements PropertyValueModel {
    protected Object value;
    protected CollectionValueModel collectionHolder;
    protected CollectionChangeListener collectionChangeListener;

    protected CollectionPropertyValueModelAdapter(CollectionValueModel collectionHolder) {
        this.collectionHolder = collectionHolder;
    }

    protected void initialize() {
        super.initialize();
        this.value = null;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.itemsRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (propertyName == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("value", this.collectionChangeListener);
        this.value = this.buildValue();
    }

    protected abstract Object buildValue();

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("value", this.collectionChangeListener);
        this.value = null;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.collectionHolder);
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void propertyChanged() {
        Object old = this.value;
        this.value = this.buildValue();
        this.firePropertyChanged("value", old, this.value);
    }
}

