/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;

public class FilteringCollectionValueModel
extends CollectionValueModelWrapper {
    private Filter filter;
    private Filter localFilter;
    private Collection filteredItems;

    public FilteringCollectionValueModel(CollectionValueModel collectionHolder) {
        this(collectionHolder, Filter.NULL_INSTANCE);
    }

    public FilteringCollectionValueModel(CollectionValueModel collectionHolder, Filter filter) {
        super(collectionHolder);
        this.filter = filter;
    }

    public FilteringCollectionValueModel(ListValueModel listHolder) {
        this(new ListCollectionValueModelAdapter(listHolder));
    }

    public FilteringCollectionValueModel(ListValueModel listHolder, Filter filter) {
        this(new ListCollectionValueModelAdapter(listHolder), filter);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.localFilter = this.buildLocalFilter();
        this.filteredItems = new ArrayList();
    }

    protected Filter buildLocalFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return FilteringCollectionValueModel.this.accept(o);
            }
        };
    }

    @Override
    public Object getValue() {
        return this.filteredItems.iterator();
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.synchFilteredItems();
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    @Override
    protected void itemsAdded(CollectionChangeEvent e) {
        this.addItemsToCollection(this.filter(e.items()), this.filteredItems, "value");
    }

    @Override
    protected void itemsRemoved(CollectionChangeEvent e) {
        this.removeItemsFromCollection(e.items(), this.filteredItems, "value");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent e) {
        this.synchFilteredItems();
        this.fireCollectionChanged("value");
    }

    protected boolean accept(Object value) {
        return this.filter.accept(value);
    }

    protected Iterator filter(Iterator items) {
        return new FilteringIterator(items, this.localFilter);
    }

    protected void synchFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll((Collection)this.filteredItems, (Iterator)this.filter((Iterator)this.collectionHolder.getValue()));
    }
}

