/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.paging;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilderImpl;
import org.eclipse.persistence.jpa.rs.features.ItemLinksBuilder;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.list.PageableCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReadAllQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultListItem;

public class PagingResponseBuilder
extends FeatureResponseBuilderImpl {
    @Override
    public Object buildReadAllQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object> items, UriInfo uriInfo) {
        ReadAllQueryResultCollection response = new ReadAllQueryResultCollection();
        for (Object item : items) {
            response.addItem(this.populatePagedReadAllQueryItemLinks(context, item));
        }
        return this.populatePagedCollectionLinks(queryParams, uriInfo, response);
    }

    @Override
    public Object buildReportQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> items, UriInfo uriInfo) {
        return this.populatePagedReportQueryCollectionLinks(queryParams, results, items, uriInfo);
    }

    @Override
    public Object buildAttributeResponse(PersistenceContext context, Map<String, Object> queryParams, String attribute, Object results, UriInfo uriInfo) {
        if (results instanceof List) {
            ReadAllQueryResultCollection response = new ReadAllQueryResultCollection();
            response.setItems((List)results);
            return this.populatePagedCollectionLinks(queryParams, uriInfo, response);
        }
        return results;
    }

    private Object populatePagedReadAllQueryItemLinks(PersistenceContext context, Object result) {
        ClassDescriptor descriptor = context.getJAXBDescriptorForClass(result.getClass());
        if (result instanceof PersistenceWeavedRest && descriptor != null) {
            PersistenceWeavedRest entity = (PersistenceWeavedRest)result;
            String href = HrefHelper.buildEntityHref(context, descriptor.getAlias(), IdHelper.stringifyId(result, descriptor.getAlias(), context));
            ItemLinks itemLinks = new ItemLinksBuilder().addSelf(href).addCanonical(href).build();
            entity._persistence_setLinks(itemLinks);
            return entity;
        }
        return result;
    }

    private PageableCollection populatePagedCollectionLinks(Map<String, Object> queryParams, UriInfo uriInfo, PageableCollection resultCollection) {
        ItemLinksBuilder itemLinksBuilder = new ItemLinksBuilder();
        int limit = Integer.parseInt((String)queryParams.get("limit"));
        int offset = Integer.parseInt((String)queryParams.get("offset"));
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uriInfo.getRequestUri());
        if (resultCollection.getItems() != null) {
            int actualCount = resultCollection.getItems().size();
            if (actualCount > limit) {
                resultCollection.getItems().remove(actualCount - 1);
                resultCollection.setCount(actualCount - 1);
                uriBuilder.replaceQueryParam("offset", new Object[]{String.valueOf(limit + offset)});
                itemLinksBuilder.addNext(uriBuilder.build(new Object[0]).toString());
                resultCollection.setHasMore(true);
            } else {
                resultCollection.setHasMore(false);
                resultCollection.setCount(actualCount);
            }
        } else {
            resultCollection.setCount(0);
        }
        if (offset != 0) {
            if (offset > limit) {
                uriBuilder.replaceQueryParam("offset", new Object[]{String.valueOf(offset - limit)});
            } else {
                uriBuilder.replaceQueryParam("offset", new Object[]{"0"});
            }
            if (resultCollection.getItems() != null && !resultCollection.getItems().isEmpty()) {
                itemLinksBuilder.addPrev(uriBuilder.build(new Object[0]).toString());
            }
        }
        itemLinksBuilder.addSelf(uriInfo.getRequestUri().toString());
        resultCollection.setLinks(itemLinksBuilder.build().getLinks());
        resultCollection.setOffset(offset);
        resultCollection.setLimit(limit);
        return resultCollection;
    }

    private PageableCollection populatePagedReportQueryCollectionLinks(Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> reportItems, UriInfo uriInfo) {
        ReportQueryResultCollection response = new ReportQueryResultCollection();
        for (Object[] result : results) {
            ReportQueryResultListItem queryResultListItem = new ReportQueryResultListItem();
            List<JAXBElement> jaxbFields = this.createShellJAXBElementList(reportItems, result);
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        response.setCount(results.size());
        return this.populatePagedCollectionLinks(queryParams, uriInfo, response);
    }
}

