/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.insurance;

import java.io.Serializable;
import java.sql.Date;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.HealthPolicy;
import org.eclipse.persistence.testing.models.insurance.HousePolicy;
import org.eclipse.persistence.testing.models.insurance.Phone;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.VehiclePolicy;

public class PolicyHolder
implements Serializable {
    private String firstName = "";
    private String lastName = "";
    private String sex = "Male";
    private long ssn;
    private Date birthDate;
    private String occupation = "";
    private Address address;
    private Vector policies = new Vector(3);
    private Vector childrenNames = new Vector(2);
    private Vector phones = new Vector(4);

    public void addChildName(String name) {
        this.getChildrenNames().addElement(name);
    }

    public void addPhone(Phone phone) {
        this.getPhones().addElement(phone);
    }

    public Policy addPolicy(Policy policy) {
        this.getPolicies().addElement(policy);
        policy.setPolicyHolder(this);
        return policy;
    }

    public static PolicyHolder example1() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("Bob");
        holder.setLastName("Smith");
        holder.addChildName("Bobby");
        holder.addChildName("Bessy-Sue");
        holder.addChildName("Bessy-Ray");
        holder.setMale();
        holder.setSsn(1111L);
        holder.setBirthDate(Helper.dateFromString((String)"1950/02/30"));
        holder.setOccupation("Engineer");
        holder.setAddress(Address.example1());
        holder.addPolicy(HealthPolicy.example1());
        holder.addPhone(Phone.example1());
        holder.addPhone(Phone.example2());
        return holder;
    }

    public static PolicyHolder example2() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("Jill");
        holder.setLastName("May");
        holder.setFemale();
        holder.setSsn(2222L);
        holder.setBirthDate(Helper.dateFromString((String)"1960/02/15"));
        holder.setOccupation("Diving");
        holder.setAddress(Address.example2());
        holder.addPolicy(HousePolicy.example1());
        holder.addPolicy(VehiclePolicy.example2());
        holder.addPhone(Phone.example3());
        holder.addPhone(Phone.example4());
        return holder;
    }

    public static PolicyHolder example3() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("Sarah");
        holder.setLastName("Way");
        holder.setFemale();
        holder.setSsn(3333L);
        holder.setBirthDate(Helper.dateFromString((String)"1977/03/03"));
        holder.setOccupation("Student");
        holder.setAddress(Address.example3());
        holder.addPolicy(HousePolicy.example2());
        return holder;
    }

    public static PolicyHolder example4() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("Sarah-loo");
        holder.setLastName("Smitty");
        holder.addChildName("Gene");
        holder.addChildName("Jen");
        holder.addChildName("Jess");
        holder.addChildName("Jean");
        holder.setFemale();
        holder.setSsn(4444L);
        holder.setBirthDate(Helper.dateFromString((String)"1919/09/09"));
        holder.setOccupation("Unemployed");
        holder.setAddress(Address.example1());
        holder.addPolicy(VehiclePolicy.example1());
        return holder;
    }

    public static PolicyHolder example5() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("Shi");
        holder.setLastName("Shu");
        holder.addChildName("tai");
        holder.addChildName("lin");
        holder.addChildName("ching");
        holder.setFemale();
        holder.setSsn(5555L);
        holder.setBirthDate(Helper.dateFromString((String)"1910/09/09"));
        holder.setOccupation("Unemployed");
        holder.setAddress(Address.example1());
        holder.addPolicy(VehiclePolicy.example3());
        return holder;
    }

    public Address getAddress() {
        return this.address;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public Vector getChildrenNames() {
        return this.childrenNames;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public Vector getPhones() {
        return this.phones;
    }

    public Vector getPolicies() {
        return this.policies;
    }

    public String getSex() {
        return this.sex;
    }

    public long getSsn() {
        return this.ssn;
    }

    public void internalSetAddress(Address address) {
        this.address = address;
    }

    public boolean isFemale() {
        return this.getSex().equals("Female");
    }

    public boolean isMale() {
        return this.getSex().equals("Male");
    }

    public void removePhone(Phone device) {
        this.getPhones().removeElement(device);
    }

    public Policy removePolicy(Policy policy) {
        this.getPolicies().removeElement(policy);
        policy.setPolicyHolder(null);
        return policy;
    }

    public void setAddress(Address address) {
        this.address = address;
        if (address != null) {
            address.setPolicyHolder(this);
        }
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public void setChildrenNames(Vector childrenNames) {
        this.childrenNames = childrenNames;
    }

    public void setFemale() {
        this.setSex("Female");
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setMale() {
        this.setSex("Male");
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public void setPhones(Vector phones) {
        this.phones = phones;
    }

    public void setPolicies(Vector policies) {
        this.policies = policies;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setSsn(long ssn) {
        this.ssn = ssn;
    }

    public String toString() {
        return "PolicyHolder: " + this.getFirstName() + " " + this.getLastName();
    }
}

