/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.TestCase;

public class CacheInvalidationPolicyCloneTest
extends TestCase {
    protected Class policyClassToTest;

    public CacheInvalidationPolicyCloneTest(Class policyClassToTest) {
        this.policyClassToTest = policyClassToTest;
        this.setName(((Object)((Object)this)).getClass().getSimpleName() + " : " + policyClassToTest.getSimpleName());
        this.setDescription("Test CacheInvalidationPolicy cloning for: " + policyClassToTest.getSimpleName());
    }

    public void test() {
        if (this.policyClassToTest == null || !Helper.classIsSubclass((Class)this.policyClassToTest, CacheInvalidationPolicy.class)) {
            this.throwError("CacheInvalidationPolicy class to test cannot be null");
        }
        if (this.policyClassToTest.equals(DailyCacheInvalidationPolicy.class)) {
            DailyCacheInvalidationPolicy policy = new DailyCacheInvalidationPolicy(1, 2, 3, 4);
            DailyCacheInvalidationPolicy policyClone = (DailyCacheInvalidationPolicy)policy.clone();
            CacheInvalidationPolicyCloneTest.assertNotNull((String)"Clone should not be null", (Object)policyClone);
            CacheInvalidationPolicyCloneTest.assertFalse((String)"Clone should not be the same instance", (policy == policyClone ? 1 : 0) != 0);
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone should be of the same type", policy.getClass(), policyClone.getClass());
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone's expiry time should be the same", (long)policy.getExpiryTime().getTimeInMillis(), (long)policyClone.getExpiryTime().getTimeInMillis());
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone's expiry time should be 01:02:03.004 - hour", (int)1, (int)policyClone.getExpiryTime().get(10));
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone's expiry time should be 01:02:03.004 - minute", (int)2, (int)policyClone.getExpiryTime().get(12));
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone's expiry time should be 01:02:03.004 - second", (int)3, (int)policyClone.getExpiryTime().get(13));
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone's expiry time should be 01:02:03.004 - millisecond", (int)4, (int)policyClone.getExpiryTime().get(14));
        } else if (this.policyClassToTest.equals(NoExpiryCacheInvalidationPolicy.class)) {
            NoExpiryCacheInvalidationPolicy policy = new NoExpiryCacheInvalidationPolicy();
            NoExpiryCacheInvalidationPolicy policyClone = (NoExpiryCacheInvalidationPolicy)policy.clone();
            CacheInvalidationPolicyCloneTest.assertNotNull((String)"Clone should not be null", (Object)policyClone);
            CacheInvalidationPolicyCloneTest.assertFalse((String)"Clone should not be the same instance", (policy == policyClone ? 1 : 0) != 0);
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone should be of the same type", policy.getClass(), policyClone.getClass());
        } else if (this.policyClassToTest.equals(TimeToLiveCacheInvalidationPolicy.class)) {
            TimeToLiveCacheInvalidationPolicy policy = new TimeToLiveCacheInvalidationPolicy();
            TimeToLiveCacheInvalidationPolicy policyClone = (TimeToLiveCacheInvalidationPolicy)policy.clone();
            CacheInvalidationPolicyCloneTest.assertNotNull((String)"Clone should not be null", (Object)policyClone);
            CacheInvalidationPolicyCloneTest.assertFalse((String)"Clone should not be the same instance", (policy == policyClone ? 1 : 0) != 0);
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone should be of the same type", policy.getClass(), policyClone.getClass());
            CacheInvalidationPolicyCloneTest.assertEquals((String)"Clone's TTL should be the same", (long)policy.getTimeToLive(), (long)policyClone.getTimeToLive());
        } else {
            this.throwError("Invalid policy class: " + this.policyClassToTest);
        }
    }
}

