/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockFineGrainedTest;

public class PessimisticLockRefreshTest
extends PessimisticLockFineGrainedTest {
    public PessimisticLockRefreshTest(short lockMode) {
        super(lockMode);
        this.setDescription("This test verifies the pessimistic locking feature works properly when set on the descriptor.  And especially only for queries  executed inside a UnitOfWork, not outside.  Outside the query should  be a regular NO_LOCK query.");
    }

    @Override
    public void test() throws Exception {
        this.checkSelectForUpateSupported();
        if (this.lockMode == 2) {
            this.checkNoWaitSupported();
        }
        ReadObjectQuery query = new ReadObjectQuery(Address.class);
        this.uow = this.getSession().acquireUnitOfWork();
        Address address = (Address)this.uow.executeQuery((DatabaseQuery)query);
        String oldCity = address.getCity();
        address.setCity("Naboo");
        query.setShouldRefreshIdentityMapResult(true);
        query.setSelectionObject((Object)address);
        Address newAddress = (Address)this.uow.executeQuery((DatabaseQuery)query);
        this.strongAssert(newAddress.getCity().equals(oldCity), "A pessimistically locked object could not be refreshed.");
        this.uow.release();
        this.uow = this.getSession().acquireUnitOfWork();
        query = new ReadObjectQuery(Address.class);
        query.dontAcquireLocks();
        address = (Address)this.uow.executeQuery((DatabaseQuery)query);
        address.setCity("Naboo");
        query = new ReadObjectQuery(Address.class);
        query.setSelectionObject((Object)address);
        newAddress = (Address)this.uow.executeQuery((DatabaseQuery)query);
        this.strongAssert(!newAddress.getCity().equals("Naboo"), "A pessimistically locked object should be refreshed when read for the first time.");
    }
}

