/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import java.rmi.Naming;
import java.rmi.RemoteException;
import junit.framework.Test;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.rmi.RMIConnection;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.remote.RMIServerManager;
import org.eclipse.persistence.testing.tests.remote.RMIServerManagerController;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;
import org.eclipse.persistence.testing.tests.remote.TransporterGenerator;
import org.eclipse.persistence.testing.tests.remote.rmi.RMIConnectionExceptionsTest;

public class RMIRemoteModel
extends RemoteModel {
    public RMIConnection createConnection() {
        RMIServerManager serverManager = null;
        try {
            serverManager = (RMIServerManager)Naming.lookup("SERVER-MANAGER");
        }
        catch (Exception exception) {
            throw new TestProblemException("RMI Lookup failed:", (Throwable)exception);
        }
        RMIConnection rmiConnection = null;
        try {
            rmiConnection = new RMIConnection(serverManager.createRemoteSessionController());
        }
        catch (RemoteException exception) {
            throw new TestProblemException("Create remote session failed:", (Throwable)exception);
        }
        return rmiConnection;
    }

    @Override
    public void setup() {
        originalSession = this.getSession();
        RMIServerManagerController.start(this.buildServerSession());
        RMIConnection connection = this.createConnection();
        Session remoteSession = connection.createRemoteSession();
        remoteSession.setSessionLog(originalSession.getSessionLog());
        this.getExecutor().setSession(remoteSession);
    }

    @Override
    public void addTests() {
        super.addTests();
        this.addTest((Test)RMIRemoteModel.getExceptionsTestSuite());
    }

    public static TestSuite getExceptionsTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExceptionsTestSuite");
        suite.setDescription("Verifies whether the right exceptions are thrown");
        suite.addTest((Test)new RMIConnectionExceptionsTest(TransporterGenerator.THROW_REMOTE_EXCEPTION));
        suite.addTest((Test)new RMIConnectionExceptionsTest(TransporterGenerator.SET_EXCEPTION_INTO_TRANSPORTER));
        return suite;
    }
}

