/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transactions;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.mapping.Employee;

public class ReadingThroughWriteConnectionInTransactionTest
extends AutoVerifyTestCase {
    protected boolean multipleClients = false;
    protected boolean useUnitOfWork = false;
    protected boolean readIntoCache = false;
    protected boolean instantiateValueHolders = false;
    protected boolean readAfterTransaction = false;
    protected String notSupportedExplanation = null;
    protected Expression searchExpression = null;
    protected Server serverSession;
    protected Vector backupReadConnections;
    protected DatabaseLogin login;
    protected Exception exception;
    protected Accessor clientWriteConnection;

    public ReadingThroughWriteConnectionInTransactionTest(String testId) {
        this.setName("ReadingThroughWriteConnectionInTransactionTest" + testId);
    }

    public boolean shouldUseMultipleClients() {
        return this.multipleClients;
    }

    public void useMultipleClients() {
        this.multipleClients = true;
    }

    public boolean shouldUseUnitOfWork() {
        return this.useUnitOfWork;
    }

    public void useUnitOfWork() {
        this.useUnitOfWork = true;
    }

    public boolean shouldReadIntoCache() {
        return this.readIntoCache;
    }

    public void readIntoCache() {
        this.readIntoCache = true;
    }

    public boolean shouldInstantiateValueHolders() {
        return this.instantiateValueHolders;
    }

    public void instantiateValueHolders() {
        this.instantiateValueHolders = true;
    }

    public boolean shouldReadAfterTransaction() {
        return this.readAfterTransaction;
    }

    public void readAfterTransaction() {
        this.readAfterTransaction = true;
    }

    protected String getNotSupportedExplanation() {
        return this.notSupportedExplanation;
    }

    protected void setNotSupportedExplanation(String notSupportedExplanation) {
        this.notSupportedExplanation = notSupportedExplanation;
    }

    protected Expression getSearchExpression() {
        return this.searchExpression;
    }

    protected void setSearchExpression(Expression searchExpression) {
        this.searchExpression = searchExpression;
    }

    protected Vector getBackupReadConnections() {
        return this.backupReadConnections;
    }

    protected void setBackupReadConnections(Vector backupReadConnections) {
        this.backupReadConnections = backupReadConnections;
    }

    protected DatabaseLogin getLogin() {
        return this.login;
    }

    protected void setLogin(DatabaseLogin login) {
        this.login = login;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    protected Accessor getClientWriteConnection() {
        return this.clientWriteConnection;
    }

    protected void setClientWriteConnection(Accessor clientWriteConnection) {
        this.clientWriteConnection = clientWriteConnection;
    }

    public static Vector buildTests() {
        Vector<ReadingThroughWriteConnectionInTransactionTest> tests = new Vector<ReadingThroughWriteConnectionInTransactionTest>(14);
        ReadingThroughWriteConnectionInTransactionTest test = null;
        test = new ReadingThroughWriteConnectionInTransactionTest("1");
        test.setDescription("base test for reading using write/transaction connection when in transaction (CR#4334).  Correct accessor used at root level and for triggered (attribute) queries.");
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("1:UOW");
        test.setDescription("base test for reading using write/transaction connection when in transaction (CR#4334).  Correct accessor used at root level and for triggered (attribute) queries.  Uses Unit of Work.");
        test.useUnitOfWork();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("2");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests correct (write) accessor used when value holder triggered by in transaction session.");
        test.setNotSupportedExplanation(new String("Unless the value holder is wrapped, as by a UOW, it will instaniate with the same connection as its parent in cache, the server read connection."));
        test.instantiateValueHolders();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("2:UOW");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests correct (write) accessor used when value holder triggered by in transaction session.  Uses Unit of Work.");
        test.instantiateValueHolders();
        test.useUnitOfWork();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("3");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests server read accessor used when value holder triggered by no longer in transaction session.");
        test.readAfterTransaction();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("3:UOW");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests server read accessor used when value holder triggered by no longer in transaction session.  Uses unit of work.");
        test.readAfterTransaction();
        test.useUnitOfWork();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("4");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests correct accessor used when value holder triggered by in transaction session, on object from global cache.");
        test.setNotSupportedExplanation(new String("A client session is not allowed to own the value holders of objects it has read, as they are put in the cache and another could potentially trigger them with your connection."));
        test.readIntoCache();
        test.instantiateValueHolders();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("6:UOW");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests server read accessor used when value holder triggered by non in transaction session, on object originally read by in transaction session.  Uses unit of work.");
        test.useMultipleClients();
        test.instantiateValueHolders();
        test.useUnitOfWork();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("7");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests server read accessor used when value holder triggered by non in transaction session, on object originally read by in transaction session that is no longer in transaction.");
        test.useMultipleClients();
        test.readAfterTransaction();
        tests.add(test);
        test = new ReadingThroughWriteConnectionInTransactionTest("7:UOW");
        test.setDescription("test for reading using write/transaction connection when in transaction (CR#4334).  Tests server read accessor used when value holder triggered by non in transaction session, on object originally read by in transaction session that is no longer in transaction.  Uses unit of work.");
        test.useMultipleClients();
        test.readAfterTransaction();
        test.useUnitOfWork();
        tests.add(test);
        return tests;
    }

    private void corruptClientWriteConnection(ClientSession client) {
        if (this.getClientWriteConnection() != null) {
            return;
        }
        this.setClientWriteConnection(client.getWriteConnection());
        if (client.isInTransaction()) {
            this.getClientWriteConnection().rollbackTransaction((AbstractSession)client);
        }
        client.setWriteConnection(null);
    }

    private void corruptServerReadConnections() {
        if (this.getBackupReadConnections() != null) {
            return;
        }
        List readConnections = this.getServerSession().getReadConnectionPool().getConnectionsAvailable();
        this.setBackupReadConnections(new Vector(readConnections));
        readConnections.clear();
        readConnections.add(null);
    }

    public Server getServerSession() {
        return this.serverSession;
    }

    public void reset() {
        try {
            this.getServerSession().logout();
        }
        catch (Exception e) {
            try {
                Iterator poolsEnum = ((ServerSession)this.getServerSession()).getConnectionPools().values().iterator();
                while (poolsEnum.hasNext()) {
                    ((ConnectionPool)poolsEnum.next()).shutDown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TestErrorException("Failed in reset.", (Throwable)e);
        }
        finally {
            this.setServerSession(null);
        }
    }

    private void restoreClientWriteConnection(ClientSession client) {
        if (this.getClientWriteConnection() != null) {
            client.setWriteConnection(this.getClientWriteConnection());
            this.setClientWriteConnection(null);
        }
    }

    private void restoreServerReadConnections() {
        if (this.getBackupReadConnections() != null) {
            List readConnections = this.getServerSession().getReadConnectionPool().getConnectionsAvailable();
            readConnections.clear();
            readConnections.addAll(this.getBackupReadConnections());
            this.setBackupReadConnections(null);
        }
    }

    public void setServerSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public void setup() {
        this.exception = null;
        try {
            this.setLogin((DatabaseLogin)this.getSession().getLogin().clone());
            this.setServerSession(new ServerSession((Login)this.login));
            this.getServerSession().useExclusiveReadConnectionPool(2, 2);
            Vector descriptors = new Vector(this.getAbstractSession().getDescriptors().values());
            this.getServerSession().addDescriptors(descriptors);
            this.getServerSession().setSessionLog(this.getSession().getSessionLog());
            this.getServerSession().login();
        }
        catch (Exception e) {
            throw new TestErrorException("Failed in setup.", (Throwable)e);
        }
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        this.setSearchExpression(builder.get("lastName").equal((Object)"Vadis"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ClientSession client = this.getServerSession().acquireClientSession();
        UnitOfWorkImpl uow = null;
        UnitOfWork uow2 = null;
        ClientSession session = null;
        Employee emp = null;
        Employee emp2 = null;
        if (this.shouldUseUnitOfWork()) {
            uow = client.acquireUnitOfWork();
            session = uow;
        } else {
            session = client;
        }
        if (this.shouldReadIntoCache()) {
            this.getServerSession().executeQuery((DatabaseQuery)new ReadObjectQuery(Employee.class, this.getSearchExpression()));
        }
        if (this.shouldUseUnitOfWork()) {
            uow.beginEarlyTransaction();
        } else {
            client.beginTransaction();
        }
        if (this.shouldUseMultipleClients()) {
            uow2 = this.getServerSession().acquireUnitOfWork();
        }
        try {
            this.corruptServerReadConnections();
            emp = (Employee)session.executeQuery((DatabaseQuery)new ReadObjectQuery(Employee.class, this.getSearchExpression()));
            if (this.shouldUseMultipleClients()) {
                this.restoreServerReadConnections();
                emp2 = (Employee)uow2.executeQuery((DatabaseQuery)new ReadObjectQuery(Employee.class, this.getSearchExpression()));
            }
            if (this.shouldInstantiateValueHolders()) {
                if (this.shouldUseMultipleClients()) {
                    this.corruptClientWriteConnection(client);
                    emp2.getPhoneNumbers();
                    emp2.getPolicies();
                    this.restoreClientWriteConnection(client);
                } else {
                    Vector phoneNumbers = emp.getPhoneNumbers();
                    phoneNumbers.size();
                    emp.getPolicies();
                }
            }
            if (this.shouldUseUnitOfWork()) {
                uow.rollbackTransaction();
            } else {
                client.rollbackTransaction();
            }
            this.restoreServerReadConnections();
            this.corruptClientWriteConnection(client);
            if (this.shouldReadAfterTransaction()) {
                if (this.shouldUseMultipleClients()) {
                    emp2.getPhoneNumbers();
                } else {
                    emp.getPhoneNumbers();
                }
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
        finally {
            this.restoreClientWriteConnection(client);
            this.restoreServerReadConnections();
            client.release();
            if (uow2 != null) {
                uow2.release();
            }
        }
    }

    public void verify() {
        if (this.getException() != null) {
            if (this.getNotSupportedExplanation() != null) {
                throw new TestWarningException("Not supported: " + this.getNotSupportedExplanation());
            }
            throw new TestErrorException("Test failed.  Either an in transaction session attempted to use a server read connection, or a session tried to use the connection of another session.");
        }
    }
}

