/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;

public class IndirectListTestAPI
extends ZTestCase {
    protected Vector<String> list;
    protected IndirectList<String> testList;
    private Listener testListLsn;
    private Class<? extends IndirectList> cls;
    private boolean useListener;

    public IndirectListTestAPI(String name) {
        this(name, null, true);
    }

    public IndirectListTestAPI(String name, Class<? extends IndirectList> cls, boolean useListener) {
        super(name);
        this.cls = cls;
        this.useListener = useListener;
    }

    public static TestSuite getTestSuiteFor(Class<? extends IndirectList> cls, boolean useListener) {
        ZTestSuite ts = new ZTestSuite("Suite for " + cls.getName() + "(useListener: " + useListener + ")");
        ts.addTest((Test)new IndirectListTestAPI("testAdd1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testAdd2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testAddAll1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testAddAll2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testAddElement", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testClear", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testContains", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testContainsAll", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testElementAt", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testElements", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testEquals", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testFirstElement", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testGet", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testHashCode", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testIndexOf1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testIndexOf2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testInsertElementAt", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testIsEmpty", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testIterator", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testLastElement", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testLastIndexOf1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testLastIndexOf2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testListIterator1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testListIterator2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRemove1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRemove2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRemoveAll", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRemoveAllElements", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRemoveElement", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRemoveElementAt", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testRetainAll", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testSet", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testSetElementAt", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testSize", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testSubList", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testToArray1", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testToArray2", cls, useListener));
        ts.addTest((Test)new IndirectListTestAPI("testSort", cls, useListener));
        if (JavaSEPlatform.atLeast((JavaSEPlatform)JavaSEPlatform.v1_8) && cls.getName().contains(".jdk8.")) {
            try {
                Constructor<?> c = Class.forName("org.eclipse.persistence.testing.tests.transparentindirection.jdk8.IndirectListTestAPI8").getConstructor(String.class, Class.class, Boolean.TYPE);
                ts.addTest((Test)((TestCase)c.newInstance("testForEach", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testParallelStream", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testRemoveIf", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testReplaceAll", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testSpliterator", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testSort", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testStream", cls, useListener)));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return ts;
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        Vector<String> temp = new Vector<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testList = IndirectCollectionsFactory.createIndirectList();
        } else {
            try {
                this.testList = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testList.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testListLsn = new Listener();
            this.testList._persistence_setPropertyChangeListener((PropertyChangeListener)this.testListLsn);
        }
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        if (this.useListener) {
            this.testListLsn.events.clear();
        }
    }

    public void testAdd1() {
        String temp = "foo";
        this.list.add(3, temp);
        this.testList.add(3, (Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    public void testAdd2() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    public void testAddAll1() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        this.assertAddEvents(2);
    }

    public void testAddAll2() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(3, temp);
        this.testList.addAll(3, temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        this.assertAddEvents(2);
    }

    public void testAddElement() {
        String temp = "foo";
        this.list.addElement(temp);
        this.testList.addElement((Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    public void testClear() {
        int originalSize = this.testList.size();
        this.list.clear();
        this.testList.clear();
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.isEmpty());
        this.assertRemoveEvents(originalSize);
    }

    public void testContains() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)this.list.elementAt(1)));
        this.assertNoEvents();
    }

    public void testContainsAll() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
        this.assertNoEvents();
    }

    public void testElementAt() {
        IndirectListTestAPI.assertEquals((String)this.list.elementAt(1), (String)((String)this.testList.elementAt(1)));
        this.assertNoEvents();
    }

    public void testElements() {
        IndirectListTestAPI.assertEquals((String)this.list.elements().nextElement(), (String)((String)this.testList.elements().nextElement()));
        this.assertNoEvents();
    }

    public void testEquals() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.equals(this.list));
        this.assertNoEvents();
    }

    public void testFirstElement() {
        IndirectListTestAPI.assertEquals((String)this.list.firstElement(), (String)((String)this.testList.firstElement()));
        this.assertNoEvents();
    }

    public void testGet() {
        IndirectListTestAPI.assertEquals((String)this.list.get(1), (String)((String)this.testList.get(1)));
        this.assertNoEvents();
    }

    public void testHashCode() {
        IndirectListTestAPI.assertEquals((int)this.list.hashCode(), (int)this.testList.hashCode());
        this.assertNoEvents();
    }

    public void testIndexOf1() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.indexOf(temp), (int)this.testList.indexOf((Object)temp));
        this.assertNoEvents();
    }

    public void testIndexOf2() {
        String temp = "seven";
        IndirectListTestAPI.assertEquals((int)this.list.indexOf(temp, 3), (int)this.testList.indexOf((Object)temp, 3));
        this.assertNoEvents();
    }

    public void testInsertElementAt() {
        String temp = "foo";
        this.list.insertElementAt(temp, 3);
        this.testList.insertElementAt((Object)temp, 3);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    public void testIsEmpty() {
        IndirectListTestAPI.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
        this.assertNoEvents();
    }

    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)i);
        this.assertNoEvents();
    }

    public void testLastElement() {
        IndirectListTestAPI.assertEquals((String)this.list.lastElement(), (String)((String)this.testList.lastElement()));
        this.assertNoEvents();
    }

    public void testLastIndexOf1() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.lastIndexOf(temp), (int)this.testList.lastIndexOf((Object)temp));
        this.assertNoEvents();
    }

    public void testLastIndexOf2() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.lastIndexOf(temp, 7), (int)this.testList.lastIndexOf((Object)temp, 7));
        this.assertNoEvents();
    }

    public void testListIterator1() {
        int i = 0;
        ListIterator stream = this.testList.listIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)i);
        this.assertNoEvents();
    }

    public void testListIterator2() {
        int i = 0;
        ListIterator stream = this.testList.listIterator(2);
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)(i + 2));
        this.assertNoEvents();
    }

    public void testRemove1() {
        String temp = this.list.remove(1);
        IndirectListTestAPI.assertEquals((Object)temp, (Object)this.testList.remove(1));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    public void testRemove2() {
        String temp = "one";
        IndirectListTestAPI.assertTrue((boolean)this.list.remove(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.remove((Object)temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectListTestAPI.assertTrue((boolean)this.list.removeAll(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeAll(temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(2);
    }

    public void testRemoveAllElements() {
        int originalSize = this.testList.size();
        this.list.removeAllElements();
        this.testList.removeAllElements();
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
        this.assertRemoveEvents(originalSize);
    }

    public void testRemoveElement() {
        String temp = "one";
        IndirectListTestAPI.assertTrue((boolean)this.list.removeElement(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeElement((Object)temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    public void testRemoveElementAt() {
        Object temp = this.testList.elementAt(1);
        this.list.removeElementAt(1);
        this.testList.removeElementAt(1);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains(temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    public void testRetainAll() {
        int originalSize = this.testList.size();
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectListTestAPI.assertTrue((boolean)this.list.retainAll(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.retainAll(temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        IndirectListTestAPI.assertEquals((int)temp.size(), (int)this.testList.size());
        this.assertRemoveEvents(originalSize - temp.size());
    }

    public void testSet() {
        String temp = "foo";
        this.list.set(3, temp);
        this.testList.set(3, (Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertRemoveAddEvents(1);
    }

    public void testSetElementAt() {
        String temp = "foo";
        this.list.setElementAt(temp, 3);
        this.testList.setElementAt((Object)temp, 3);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertRemoveAddEvents(1);
    }

    public void testSize() {
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)this.testList.size());
        this.assertNoEvents();
    }

    public void testSubList() {
        IndirectListTestAPI.assertEquals(this.list.subList(2, 5), (Object)this.testList.subList(2, 5));
        this.assertNoEvents();
    }

    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        IndirectListTestAPI.assertEquals(v1, v2);
        this.assertNoEvents();
    }

    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        IndirectListTestAPI.assertEquals(v1, v2);
        this.assertNoEvents();
    }

    public void testSort() {
        this.assertElementsEqual(this.list, (Vector)this.testList);
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        Collections.sort(this.list, c);
        this.testList.sort((Comparator)c);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertNoEvents();
    }

    protected void assertNoEvents() {
        if (this.useListener) {
            IndirectListTestAPI.assertTrue((boolean)this.testListLsn.events.isEmpty());
        }
    }

    protected void assertAddEvents(int count) {
        if (this.useListener) {
            IndirectListTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectListTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)cce.getChangeType());
            }
        }
    }

    protected void assertRemoveEvents(int count) {
        if (this.useListener) {
            IndirectListTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectListTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.REMOVE, (int)cce.getChangeType());
            }
        }
    }

    protected void assertRemoveAddEvents(int count) {
        if (this.useListener) {
            int totalEvents = count * 2;
            IndirectListTestAPI.assertEquals((String)"events do not match", (int)totalEvents, (int)this.testListLsn.events.size());
            int i = 0;
            while (i < totalEvents) {
                CollectionChangeEvent removeEvent = (CollectionChangeEvent)this.testListLsn.events.get(i++);
                CollectionChangeEvent addEvent = (CollectionChangeEvent)this.testListLsn.events.get(i++);
                IndirectListTestAPI.assertEquals((String)"expected remove event", (int)CollectionChangeEvent.REMOVE, (int)removeEvent.getChangeType());
                IndirectListTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)addEvent.getChangeType());
                IndirectListTestAPI.assertFalse((String)("removed: '" + removeEvent.getNewValue() + "', new: '" + addEvent.getNewValue() + "'"), (boolean)removeEvent.getNewValue().equals(addEvent.getNewValue()));
            }
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<CollectionChangeEvent> events = new ArrayList<CollectionChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((CollectionChangeEvent)evt);
        }
    }
}

