/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Resource;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class TransparentIndirectionTest
extends AutoVerifyTestCase {
    public SalesPerson transfer;
    public SalesPerson transfer2;
    public FieldOffice clone;
    public FieldOffice clone2;
    public Resource resource;

    public TransparentIndirectionTest() {
        this.setDescription("This test verifies that Tranparent Indirection works with change tracking");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.clone = (FieldOffice)uow.readObject(FieldOffice.class, new ExpressionBuilder().get("location").get("city").equal((Object)"Toronto"));
        this.clone2 = (FieldOffice)uow.readObject(FieldOffice.class, new ExpressionBuilder().get("location").get("city").equal((Object)"Ottawa"));
        this.transfer = (SalesPerson)this.clone.getSalespeople().iterator().next();
        this.transfer2 = (SalesPerson)this.clone2.getSalespeople().iterator().next();
        this.clone2.getSalespeople().remove(this.transfer2);
        this.transfer2.setFieldOffice(null);
        HashSet<SalesPerson> sales = new HashSet<SalesPerson>(this.clone2.getSalespeople());
        sales.add(this.transfer);
        this.clone.getSalespeople().remove(this.transfer);
        this.clone.getSalespeople().add(this.transfer2);
        this.transfer2.setFieldOffice(this.clone);
        this.clone2.setSalespeople(sales);
        this.transfer.setFieldOffice(this.clone2);
        this.resource = (Resource)this.clone.getResources().iterator().next();
        this.clone.getResources().remove(this.resource);
        ArrayList<Resource> list = new ArrayList<Resource>(this.clone2.getResources());
        list.add(this.resource);
        this.clone2.setResources(list);
        this.resource.setOffice(this.clone2);
        uow.commit();
    }

    public void verify() {
        FieldOffice cachedOffice = (FieldOffice)this.getSession().readObject((Object)this.clone);
        FieldOffice cachedOffice2 = (FieldOffice)this.getSession().readObject((Object)this.clone2);
        SalesPerson cachedTransfer = (SalesPerson)this.getSession().readObject((Object)this.transfer);
        SalesPerson cachedTransfer2 = (SalesPerson)this.getSession().readObject((Object)this.transfer2);
        Resource cachedResource = (Resource)this.getSession().readObject((Object)this.resource);
        if (cachedOffice.getSalespeople().contains(cachedTransfer)) {
            throw new TestErrorException("Failed to track changes from indirect list with transparent indirection");
        }
        if (!cachedOffice2.getSalespeople().contains(cachedTransfer)) {
            throw new TestErrorException("Failed to track changes when new entire collection set with transparent indirection");
        }
        if (cachedOffice2.getSalespeople().contains(cachedTransfer2)) {
            throw new TestErrorException("Failed to merge changes from indirect list with transparent indirection");
        }
        if (!cachedOffice.getSalespeople().contains(cachedTransfer2)) {
            throw new TestErrorException("Failed to merge changes when new entire collection set with transparent indirection");
        }
        if (cachedOffice.getResources().contains(cachedResource)) {
            throw new TestErrorException("Failed to track changes from indirect list without indirection");
        }
        if (!cachedOffice2.getResources().contains(cachedResource)) {
            throw new TestErrorException("Failed to track changes when new entire collection set without indirection");
        }
    }
}

