/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class TableCreatorSourceGenerationCoordinator {
    private WorkbenchContext context;

    TableCreatorSourceGenerationCoordinator(WorkbenchContext context) {
        this.initialize(context);
    }

    private void initialize(WorkbenchContext ctx) {
        this.context = ctx;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    void exportTableCreatorSource(MWRelationalProject project) {
        try {
            this.validateTableCreatorClassName(project);
            this.validateTableCreatorSourceRootDirectory(project);
            this.validateProjectProblems(project);
            this.validateOverwriteFile(project);
        }
        catch (CancelException ce) {
            return;
        }
        try {
            project.exportTableCreatorSource();
        }
        catch (RuntimeException e) {
            return;
        }
        this.showSuccessDialog((MWProject)project);
    }

    private void validateTableCreatorClassName(MWRelationalProject project) {
        String tableCreatorClassName = project.getTableCreatorSourceClassName();
        if (!tableCreatorClassName.equals("") && !tableCreatorClassName.endsWith(".")) {
            return;
        }
        TableCreatorClassNameDialog dlg = new TableCreatorClassNameDialog(this.context, this.buildTableCreatorClassNameHolder(tableCreatorClassName), (MWProject)project);
        dlg.show();
        if (dlg.wasCanceled()) {
            throw new CancelException();
        }
        project.setTableCreatorSourceClassName(dlg.getTableCreatorClassName());
    }

    private PropertyValueModel buildTableCreatorClassNameHolder(String name) {
        return new SimplePropertyValueModel(name);
    }

    private void validateTableCreatorSourceRootDirectory(MWRelationalProject project) {
        if (project.getTableCreatorSourceDirectoryName().equals("")) {
            this.promptForTableCreatorSourceRootDirectory(project);
        }
        if (project.absoluteTableCreatorSourceDirectory().isFile()) {
            this.promptForNonFileTableCreatorSourceRootDirectory(project);
        }
        if (!project.absoluteTableCreatorSourceDirectory().exists()) {
            this.promptToCreateTableCreatorSourceRootDirectory(project);
        }
    }

    private void validateProjectProblems(MWRelationalProject project) {
    }

    private void validateOverwriteFile(MWRelationalProject project) {
        File tableCreatorFile = project.tableCreatorSourceFile();
        String tableCreatorFilePath = tableCreatorFile.getAbsolutePath();
        try {
            tableCreatorFilePath = tableCreatorFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!tableCreatorFile.exists()) {
            return;
        }
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("TABLE_CREATOR_FILE_EXISTS_DIALOG.message", new Object[]{tableCreatorFilePath}), this.resourceRepository().getString("TABLE_CREATOR_FILE_EXISTS_DIALOG.title"), 0, 3);
        if (input != 0) {
            throw new CancelException();
        }
    }

    private void promptForTableCreatorSourceRootDirectory(MWRelationalProject project) {
        String description = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_NO_DIRECTORY_CHOSEN.message");
        this.promptForDirectory(project, description);
    }

    private void promptForNonFileTableCreatorSourceRootDirectory(MWRelationalProject project) {
        String description = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_A_FILE.message", new Object[]{project.absoluteTableCreatorSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private void promptForValidTableCreatorSourceRootDirectory(MWRelationalProject project) {
        String description = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_INVALID.message", new Object[]{project.absoluteTableCreatorSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private void promptForCreatableTableCreatorSourceRootDirectory(MWRelationalProject project) {
        String description = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_COULD_NOT_BE_CREATED.message", new Object[]{project.absoluteTableCreatorSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private void promptForDirectory(MWRelationalProject project, String description) {
        File startDir = MappingsPlugin.buildExportDirectory((MWProject)project, project.getTableCreatorSourceDirectoryName(), this.preferences());
        FileChooser fileChooser = new FileChooser(startDir, project.getSaveDirectory());
        fileChooser.setDialogTitle(this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG.title", project.getName()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText(this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        fileChooser.setApproveButtonMnemonic(this.resourceRepository().getMnemonic("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        int option = fileChooser.showOpenDialog(this.context.getCurrentWindow());
        if (option == 1) {
            throw new CancelException();
        }
        File directory = ((JFileChooser)fileChooser).getSelectedFile();
        project.setTableCreatorSourceDirectoryName(directory.getPath());
        if (directory != null && directory.isAbsolute() && !directory.equals(project.getSaveDirectory())) {
            this.preferences().put("export location", directory.getPath());
        }
    }

    private void promptToCreateTableCreatorSourceRootDirectory(MWRelationalProject project) {
        File canonicalDirectory;
        try {
            canonicalDirectory = project.absoluteTableCreatorSourceDirectory().getCanonicalFile();
        }
        catch (IOException ioe) {
            this.promptForValidTableCreatorSourceRootDirectory(project);
            return;
        }
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("CREATE_TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG.message", new Object[]{canonicalDirectory}), this.resourceRepository().getString("CREATE_TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG.title"), 2, 3);
        if (input == 2) {
            throw new CancelException();
        }
        if (!project.absoluteTableCreatorSourceDirectory().mkdirs()) {
            this.promptForCreatableTableCreatorSourceRootDirectory(project);
        }
    }

    private void showSuccessDialog(MWProject project) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_TABLE_CREATOR_SOURCE_SUCCESS_DIALOG.message"), this.resourceRepository().getString("GENERATE_TABLE_CREATOR_SOURCE_SUCCESS_DIALOG.title", project.getName()), 1);
    }

    private class TableCreatorClassNameDialog
    extends AbstractDialog {
        private JTextField tableCreatorClassNameTextField;
        private PropertyValueModel tableCreatorClassNameHolder;
        private static final long serialVersionUID = 1L;

        private TableCreatorClassNameDialog(WorkbenchContext context, PropertyValueModel tableCreatorClassNameHolder, MWProject project) {
            super(context);
            this.tableCreatorClassNameHolder = tableCreatorClassNameHolder;
            this.initialize(project);
        }

        protected void initialize(MWProject project) {
            super.initialize();
            this.setTitle(this.resourceRepository().getString("TABLE_CREATOR_CLASS_NAME_DIALOG.title", project.getName()));
            this.getOKAction().setEnabled(false);
        }

        @Override
        protected String helpTopicId() {
            return "dialog.tableCreatorClassName";
        }

        @Override
        protected Component buildMainPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel messageLabel = new JLabel();
            messageLabel.setText(this.resourceRepository().getString("TABLE_CREATOR_CLASS_NAME_DIALOG.message"));
            messageLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TABLE_CREATOR_CLASS_NAME_DIALOG.message"));
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 0, 5);
            panel.add((Component)messageLabel, constraints);
            this.tableCreatorClassNameTextField = this.buildTableCreatorClassNameTextField();
            messageLabel.setLabelFor(this.tableCreatorClassNameTextField);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)this.tableCreatorClassNameTextField, constraints);
            return panel;
        }

        private JTextField buildTableCreatorClassNameTextField() {
            JTextField textField = new JTextField();
            textField.setDocument(this.buildTableCreatorClassNameDocumentAdapter());
            return textField;
        }

        private Document buildTableCreatorClassNameDocumentAdapter() {
            DocumentAdapter adapter = new DocumentAdapter(this.tableCreatorClassNameHolder, new RegexpDocument(3));
            adapter.addDocumentListener(this.buildTableCreatorClassNameDocumentListener());
            return adapter;
        }

        @Override
        protected Component initialFocusComponent() {
            return this.tableCreatorClassNameTextField;
        }

        String getTableCreatorClassName() {
            return (String)this.tableCreatorClassNameHolder.getValue();
        }

        private DocumentListener buildTableCreatorClassNameDocumentListener() {
            return new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent de) {
                    TableCreatorClassNameDialog.this.tableCreatorClassNameChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent de) {
                    TableCreatorClassNameDialog.this.tableCreatorClassNameChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent de) {
                    TableCreatorClassNameDialog.this.tableCreatorClassNameChanged();
                }
            };
        }

        void tableCreatorClassNameChanged() {
            String tableCreatorClassName = this.getTableCreatorClassName();
            this.getOKAction().setEnabled(!tableCreatorClassName.equals("") && !tableCreatorClassName.endsWith("."));
        }
    }
}

