/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class DefaultingContainerClass
extends MWModel {
    private volatile boolean usesDefaultContainerClass;
    public static final String USES_DEFAULT_CONTAINER_CLASS_PROPERTY = "usesDefaultContainerClass";
    private MWClassHandle containerClassHandle;
    public static final String CONTAINER_CLASS_PROPERTY = "containerClass";

    private DefaultingContainerClass() {
    }

    DefaultingContainerClass(MWContainerPolicy parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.containerClassHandle = new MWClassHandle(this, this.buildContainerClassScrubber());
        this.usesDefaultContainerClass = true;
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.containerClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildContainerClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                DefaultingContainerClass.this.setContainerClass(null);
            }

            public String toString() {
                return "DefaultingContainerClass.buildContainerClassScrubber()";
            }
        };
    }

    private MWContainerPolicy getContainerPolicy() {
        return (MWContainerPolicy)this.getParent();
    }

    public boolean usesDefaultContainerClass() {
        return this.usesDefaultContainerClass;
    }

    public void setUseDefaultContainerClass(boolean newUsesDefaultContainerClass) {
        if (newUsesDefaultContainerClass == this.usesDefaultContainerClass) {
            return;
        }
        boolean oldUsesDefaultContainerClass = this.usesDefaultContainerClass;
        MWClass oldContainerClass = this.getContainerClass();
        this.setUseDefaultContainerClassInternal(newUsesDefaultContainerClass);
        if (this.usesDefaultContainerClass) {
            this.setContainerClassInternal(null);
        } else if (oldUsesDefaultContainerClass) {
            this.setContainerClassInternal(oldContainerClass);
        }
    }

    private void setUseDefaultContainerClassInternal(boolean newUsesDefaultContainerClass) {
        boolean oldUsesDefaultContainerClass = this.usesDefaultContainerClass;
        this.usesDefaultContainerClass = newUsesDefaultContainerClass;
        this.firePropertyChanged(USES_DEFAULT_CONTAINER_CLASS_PROPERTY, oldUsesDefaultContainerClass, newUsesDefaultContainerClass);
    }

    public MWClass getContainerClass() {
        if (this.usesDefaultContainerClass()) {
            return this.getContainerPolicy().defaultContainerClass();
        }
        return this.containerClassHandle.getType();
    }

    public void setContainerClass(MWClass newContainerClass) {
        this.setContainerClassInternal(newContainerClass);
        if (newContainerClass != null) {
            this.setUseDefaultContainerClassInternal(false);
        }
    }

    private void setContainerClassInternal(MWClass newContainerClass) {
        MWClass oldContainerClass = this.getContainerClass();
        this.containerClassHandle.setType(newContainerClass);
        this.firePropertyChanged(CONTAINER_CLASS_PROPERTY, oldContainerClass, newContainerClass);
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkContainerClass(currentProblems);
    }

    private void checkContainerClass(List currentProblems) {
        if (this.getContainerClass() == null) {
            currentProblems.add(this.buildProblem("0470"));
        } else if (!this.getContainerClass().isInstantiable()) {
            currentProblems.add(this.buildProblem("0473"));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(DefaultingContainerClass.class);
        XMLDirectMapping usesDefaultContainerClassMapping = new XMLDirectMapping();
        usesDefaultContainerClassMapping.setAttributeName(USES_DEFAULT_CONTAINER_CLASS_PROPERTY);
        usesDefaultContainerClassMapping.setXPath("uses-default-container-class/text()");
        usesDefaultContainerClassMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)usesDefaultContainerClassMapping);
        XMLCompositeObjectMapping containerClassMapping = new XMLCompositeObjectMapping();
        containerClassMapping.setAttributeName("containerClassHandle");
        containerClassMapping.setSetMethodName("setContainerClassHandleForTopLink");
        containerClassMapping.setGetMethodName("getContainerClassHandleForTopLink");
        containerClassMapping.setReferenceClass(MWClassHandle.class);
        containerClassMapping.setXPath("container-class-handle");
        descriptor.addMapping((DatabaseMapping)containerClassMapping);
        return descriptor;
    }

    private MWClassHandle getContainerClassHandleForTopLink() {
        return this.containerClassHandle.getType() == null ? null : this.containerClassHandle;
    }

    private void setContainerClassHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildContainerClassScrubber();
        this.containerClassHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

