/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.SchemaPerMultitenantPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ClientSessionIdentityMapAccessor;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ClientSession
extends AbstractSession {
    protected ServerSession parent;
    protected ConnectionPolicy connectionPolicy;
    protected Map<String, Accessor> writeConnections;
    protected boolean isActive;
    protected Sequencing sequencing;

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        this(parent, connectionPolicy, null);
    }

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        SchemaPerMultitenantPolicy mp;
        if (parent.hasTablePerTenantDescriptors() || parent.getProject().getMultitenantPolicy() != null) {
            this.project = parent.getProject().clone();
            this.project.setJPQLParseCacheMaxSize(parent.getProject().getJPQLParseCache().getMaxSize());
        } else {
            this.project = parent.getProject();
        }
        if (connectionPolicy.isUserDefinedConnection()) {
            this.setProject(this.getProject().clone());
            this.setLogin(connectionPolicy.getLogin());
        }
        if (this.project.getMultitenantPolicy() != null && this.project.getMultitenantPolicy().isSchemaPerMultitenantPolicy() && (mp = (SchemaPerMultitenantPolicy)this.project.getMultitenantPolicy()).shouldUseSharedEMF()) {
            this.setLogin(this.getLogin().clone());
        }
        this.isLoggingOff = parent.isLoggingOff();
        this.isActive = true;
        this.externalTransactionController = parent.getExternalTransactionController();
        this.parent = parent;
        this.connectionPolicy = connectionPolicy;
        this.name = parent.getName();
        this.profiler = parent.getProfiler();
        this.serializer = parent.getSerializer();
        this.isInProfile = parent.isInProfile();
        this.commitManager = parent.getCommitManager();
        this.partitioningPolicy = parent.getPartitioningPolicy();
        this.sessionLog = parent.getSessionLog();
        if (parent.hasEventManager()) {
            this.eventManager = parent.getEventManager().clone(this);
        }
        this.exceptionHandler = parent.getExceptionHandler();
        this.pessimisticLockTimeoutDefault = parent.getPessimisticLockTimeoutDefault();
        this.queryTimeoutDefault = parent.getQueryTimeoutDefault();
        this.queryTimeoutUnitDefault = parent.getQueryTimeoutUnitDefault();
        this.isConcurrent = parent.isConcurrent();
        this.shouldOptimizeResultSetAccess = parent.shouldOptimizeResultSetAccess();
        this.properties = properties;
        this.multitenantContextProperties = parent.getMultitenantContextProperties();
        if (this.eventManager != null) {
            this.eventManager.postAcquireClientSession();
        }
        if (parent.hasTablePerTenantQueries()) {
            for (DatabaseQuery query : parent.getTablePerTenantQueries()) {
                this.addTablePerTenantQuery((DatabaseQuery)query.clone());
            }
        }
        if (parent.hasTablePerTenantDescriptors()) {
            this.descriptors = new HashMap();
            this.descriptors.putAll(parent.getDescriptors());
            for (ClassDescriptor descriptor : parent.getTablePerTenantDescriptors()) {
                ClassDescriptor clonedDescriptor = (ClassDescriptor)descriptor.clone();
                this.addTablePerTenantDescriptor(clonedDescriptor);
                this.descriptors.put(clonedDescriptor.getJavaClass(), clonedDescriptor);
            }
            if (this.hasProperties()) {
                for (Cloneable propertyName : properties.keySet()) {
                    this.updateTablePerTenantDescriptors((String)((Object)propertyName), properties.get(propertyName));
                }
            }
        } else {
            this.descriptors = parent.getDescriptors();
        }
        this.incrementProfile("Counter:ClientSessionCreates");
    }

    protected ClientSession(Project project) {
        super(project);
    }

    @Override
    public void releaseJTSConnection() {
        if (this.hasWriteConnection()) {
            for (Accessor accessor : this.getWriteConnections().values()) {
                accessor.closeJTSConnection();
            }
            this.releaseWriteConnection();
        }
    }

    @Override
    public void basicCommitTransaction() {
        super.basicCommitTransaction();
        if (this.hasExternalTransactionController()) {
            if (!this.isSynchronized()) {
                this.releaseJTSConnection();
            }
        } else {
            this.releaseWriteConnection();
        }
    }

    @Override
    public void basicRollbackTransaction() {
        try {
            if (this.hasWriteConnection()) {
                super.basicRollbackTransaction();
            }
        }
        finally {
            if (this.hasExternalTransactionController()) {
                if (!this.isSynchronized()) {
                    this.releaseJTSConnection();
                }
            } else {
                this.releaseWriteConnection();
            }
        }
    }

    public void connect(Accessor accessor) throws DatabaseException {
        accessor.connect(this.getDatasourceLogin(), this);
    }

    @Override
    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (!containsQuery) {
            containsQuery = this.parent.containsQuery(queryName);
        }
        return containsQuery;
    }

    public void disconnect(Accessor accessor) throws DatabaseException {
        accessor.disconnect(this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if ((!this.isInTransaction() || query.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)query).isReadOnly()) && !this.isExclusiveIsolatedClientSession()) {
            return this.parent.executeCall(call, translationRow, query);
        }
        shouldReleaseConnection = false;
        if (!(query.getAccessors() != null || this.hasWriteConnection() && this.isExclusiveIsolatedClientSession() || (accessors = this.getAccessors(call, translationRow, query)) == null || accessors.isEmpty())) {
            query.setAccessors(accessors);
            v0 = shouldReleaseConnection = this.isActive == false;
        }
        if (query.getAccessors() == null) {
            if (!this.hasWriteConnection()) {
                this.parent.acquireClientConnection(this);
                shouldReleaseConnection = this.isActive == false;
                query.setAccessors(this.getAccessors());
            } else if (!this.isExclusiveIsolatedClientSession() && this.connectionPolicy.isPooled()) {
                defaultWriteConnection = this.writeConnections.get(this.connectionPolicy.getPoolName());
                if (defaultWriteConnection == null) {
                    this.parent.acquireClientConnection(this);
                }
                if (this.writeConnections.size() == 1) {
                    query.setAccessors(this.getAccessors());
                } else {
                    accessors = new ArrayList<Accessor>(1);
                    accessors.add(defaultWriteConnection);
                    query.setAccessors(accessors);
                }
            } else {
                query.setAccessors(this.getAccessors());
            }
        }
        result = null;
        exception = null;
        try {
            try {
                result = this.basicExecuteCall(call, translationRow, query);
            }
            catch (RuntimeException caughtException) {
                exception = caughtException;
                if (call.isFinished() || exception != null) {
                    query.setAccessors(null);
                    if (shouldReleaseConnection && this.hasWriteConnection()) {
                        try {
                            this.parent.releaseClientSession(this);
                        }
                        catch (RuntimeException releaseException) {
                            if (exception != null) ** GOTO lbl46
                            throw releaseException;
                        }
                    }
                } else if (query.isObjectLevelReadQuery()) {
                    ((DatabaseCall)call).setHasAllocatedConnection(shouldReleaseConnection);
                }
lbl46:
                // 6 sources

                if (exception != null) {
                    throw exception;
                }
            }
        }
        finally {
            if (call.isFinished() || exception != null) {
                query.setAccessors(null);
                if (shouldReleaseConnection && this.hasWriteConnection()) {
                    try {
                        this.parent.releaseClientSession(this);
                    }
                    catch (RuntimeException releaseException) {
                        if (exception != null) ** GOTO lbl62
                        throw releaseException;
                    }
                }
            } else if (query.isObjectLevelReadQuery()) {
                ((DatabaseCall)call).setHasAllocatedConnection(shouldReleaseConnection);
            }
lbl62:
            // 6 sources

            if (exception != null) {
                throw exception;
            }
        }
        return result;
    }

    @Override
    public void releaseConnectionAfterCall(DatabaseQuery query) {
        if ((!this.isInTransaction() || query.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)query).isReadOnly()) && !this.isExclusiveIsolatedClientSession()) {
            this.parent.releaseConnectionAfterCall(query);
        } else if (this.hasWriteConnection()) {
            query.setAccessors(null);
            this.parent.releaseClientSession(this);
        }
    }

    @Override
    public Collection<Accessor> getAccessors() {
        if (this.isInTransaction()) {
            if (this.writeConnections == null) {
                return null;
            }
            return this.writeConnections.values();
        }
        return this.accessors;
    }

    @Override
    public Accessor getAccessor() {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null || accessors.isEmpty()) {
            if (this.isInTransaction()) {
                this.parent.acquireClientConnection(this);
                accessors = this.getAccessors();
            } else {
                return this.parent.getAccessor();
            }
        }
        if (accessors instanceof List) {
            return (Accessor)((List)accessors).get(0);
        }
        return accessors.iterator().next();
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public Map<Class, ClassDescriptor> getDescriptors() {
        if (this.hasTablePerTenantDescriptors()) {
            return this.descriptors;
        }
        return super.getDescriptors();
    }

    @Override
    public AbstractSession getParentIdentityMapSession(ClassDescriptor descriptor, boolean canReturnSelf, boolean terminalOnly) {
        return this.parent.getParentIdentityMapSession(descriptor, canReturnSelf, terminalOnly);
    }

    @Override
    public Object getProperty(String name) {
        Object propertyValue = super.getProperty(name);
        if (propertyValue == null) {
            propertyValue = this.parent.getProperty(name);
        }
        return propertyValue;
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.isInTransaction()) {
            return this;
        }
        return this.parent.getExecutionSession(query);
    }

    @Override
    public ServerSession getParent() {
        return this.parent;
    }

    @Override
    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.parent.getQuery(name);
        }
        return query;
    }

    @Override
    public DatabaseQuery getQuery(String name, Vector args) {
        DatabaseQuery query = super.getQuery(name, args);
        if (query == null) {
            query = this.parent.getQuery(name, args);
        }
        return query;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    @Override
    public Sequencing getSequencing() {
        if (this.sequencing == null) {
            this.initializeSequencing();
        }
        return this.sequencing;
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return this.parent.getServerPlatform();
    }

    @Override
    public String getSessionTypeString() {
        return "ClientSession";
    }

    public Map<String, Accessor> getWriteConnections() {
        if (this.writeConnections == null) {
            this.writeConnections = new HashMap<String, Accessor>(4);
        }
        return this.writeConnections;
    }

    public Accessor getWriteConnection() {
        if (this.writeConnections == null || this.writeConnections.isEmpty()) {
            return null;
        }
        return this.writeConnections.values().iterator().next();
    }

    public boolean hasWriteConnection() {
        if (this.writeConnections == null) {
            return false;
        }
        return !this.writeConnections.isEmpty();
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new ClientSessionIdentityMapAccessor(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isClientSession() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.parent.isConnected();
    }

    @Override
    public void release() throws DatabaseException {
        if (!this.isActive) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.preReleaseClientSession();
        }
        if (this.hasWriteConnection()) {
            this.parent.releaseClientSession(this);
        }
        this.isActive = false;
        this.log(2, "connection", "client_released");
        if (this.eventManager != null) {
            this.eventManager.postReleaseClientSession();
        }
        this.incrementProfile("Counter:ClientSessionReleases");
    }

    @Override
    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        this.getParent().releaseInvalidClientSession(this);
        return super.retryQuery(query, row, databaseException, retryCount, executionSession);
    }

    protected void releaseWriteConnection() {
        if (this.connectionPolicy.isLazy() && this.hasWriteConnection()) {
            this.parent.releaseClientSession(this);
        }
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    protected void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setParent(ServerSession parent) {
        this.parent = parent;
    }

    public Accessor addWriteConnection(String poolName, Accessor writeConnection) {
        this.getWriteConnections().put(poolName, writeConnection);
        writeConnection.createCustomizer(this);
        if (!writeConnection.usesExternalConnectionPooling()) {
            this.postAcquireConnection(writeConnection);
        }
        if (this.isInTransaction()) {
            this.basicBeginTransaction(writeConnection);
        }
        return this.getWriteConnections().get(poolName);
    }

    @Override
    public DatabaseException retryTransaction(Accessor writeConnection, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        if (writeConnection.getPool() == null) {
            return super.retryTransaction(writeConnection, databaseException, retryCount, executionSession);
        }
        String poolName = writeConnection.getPool().getName();
        DatabaseLogin login = this.getLogin();
        int count = login.getQueryRetryAttemptCount();
        DatabaseException exceptionToThrow = databaseException;
        while (retryCount < count) {
            this.getWriteConnections().remove(poolName);
            if (!writeConnection.usesExternalConnectionPooling()) {
                this.preReleaseConnection(writeConnection);
            }
            writeConnection.getPool().releaseConnection(writeConnection);
            try {
                writeConnection = writeConnection.getPool().acquireConnection();
                writeConnection.beginTransaction(this);
                if (++retryCount > 1) {
                    Thread.currentThread();
                    Thread.sleep(login.getDelayBetweenConnectionAttempts());
                }
                this.getWriteConnections().put(poolName, writeConnection);
                writeConnection.createCustomizer(this);
                if (!writeConnection.usesExternalConnectionPooling()) {
                    this.postAcquireConnection(writeConnection);
                }
                return null;
            }
            catch (DatabaseException ex) {
                exceptionToThrow = ex;
            }
            catch (InterruptedException interruptedException) {}
        }
        return exceptionToThrow;
    }

    public void setWriteConnections(Map<String, Accessor> writeConnections) {
        if (this.writeConnections != null && writeConnections == null) {
            for (Accessor accessor : this.writeConnections.values()) {
                accessor.releaseCustomizer(this);
            }
        }
        this.writeConnections = writeConnections;
    }

    public void setWriteConnection(Accessor writeConnection) {
        if (writeConnection == null) {
            this.setWriteConnections(null);
            return;
        }
        String poolName = null;
        poolName = writeConnection.getPool() != null ? writeConnection.getPool().getName() : "not-pooled";
        this.addWriteConnection(poolName, writeConnection);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString());
        writer.write("(");
        writer.write(String.valueOf(this.getWriteConnections()));
        writer.write(")");
        return writer.toString();
    }

    @Override
    public CommandManager getCommandManager() {
        return this.parent.getCommandManager();
    }

    @Override
    public boolean shouldPropagateChanges() {
        return this.parent.shouldPropagateChanges();
    }

    @Override
    public void releaseReadConnection(Accessor connection) {
        if (this.writeConnections != null && this.writeConnections.containsValue(connection)) {
            return;
        }
        this.parent.releaseReadConnection(connection);
    }

    @Override
    public boolean isExclusiveConnectionRequired() {
        return !this.connectionPolicy.isLazy && this.isActive();
    }
}

