/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Address;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Customer;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Customers;
import org.eclipse.persistence.testing.models.jpa.jaxrs.JAXRSPopulator;
import org.eclipse.persistence.testing.models.jpa.jaxrs.JAXRSTableCreator;
import org.eclipse.persistence.testing.models.jpa.jaxrs.PhoneNumber;

public class DefaultJAXBContextTestCases
extends JUnitTestCase {
    private JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Customer.class, Customers.class});
    protected DatabaseSession session;

    public DefaultJAXBContextTestCases(String name) throws Exception {
        super(name);
    }

    public JAXRSPopulator setup() {
        this.session = JUnitTestCase.getServerSession();
        JAXRSTableCreator tableCreator = new JAXRSTableCreator();
        tableCreator.dropTableConstraints((Session)this.session);
        tableCreator.replaceTables(this.session);
        JAXRSPopulator jaxrsPopulator = new JAXRSPopulator();
        return jaxrsPopulator;
    }

    public void cleanTables(JAXRSPopulator populator) {
        populator.removeRegisteredObjects();
    }

    public void testGetCustomer() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer4();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/4");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Customer testObject = (Customer)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        int response = connection.getResponseCode();
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject4(), (Object)testObject);
    }

    public void testGetCustomerJSON() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer5();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/5");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        Customer testObject = (Customer)u.unmarshal((Source)json, Customer.class).getValue();
        int response = connection.getResponseCode();
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject5(), (Object)testObject);
    }

    public void testGetCollectionOfObjects() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer1and3and10();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/findCustomerByCity/Ottawa");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Customers testObject = (Customers)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        int response = connection.getResponseCode();
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObjects(), (Object)testObject);
    }

    public void testGetCollectionOfObjectsJSON() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer13and14and15();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/findCustomerByCity/Montreal");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        List customers = (List)u.unmarshal((Source)json, Customer.class).getValue();
        int response = connection.getResponseCode();
        connection.disconnect();
        Customers testObject = new Customers();
        testObject.setCustomer(customers);
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObjectsJSON(), (Object)testObject);
    }

    public void testDeleteCustomer() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer10();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/" + 10);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        int response = connection.getResponseCode();
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((int)204, (int)response);
    }

    public void testPostInsertCustomer() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildEmptyTables();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/xml");
        OutputStream os = connection.getOutputStream();
        this.getJAXBContext().createMarshaller().marshal((Object)this.getControlObject6(), os);
        os.flush();
        int response = connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPut(6);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject6(), (Object)testObject);
    }

    public void testPostInsertCustomerJSON() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildEmptyTables();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        Marshaller m = this.getJAXBContext().createMarshaller();
        m.setProperty("eclipselink.media-type", (Object)"application/json");
        m.setProperty("eclipselink.json.include-root", (Object)false);
        m.marshal((Object)this.getControlObject7(), os);
        os.flush();
        int response = connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPutJSON(7);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject7(), (Object)testObject);
    }

    public void testPutUpdateCustomer() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer8();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/xml");
        OutputStream os = connection.getOutputStream();
        this.getJAXBContext().createMarshaller().marshal((Object)this.getControlObject8(), os);
        os.flush();
        int response = connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPut(8);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject8(), (Object)testObject);
    }

    public void testPutUpdateCustomerJSON() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer9();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        Marshaller m = this.getJAXBContext().createMarshaller();
        m.setProperty("eclipselink.media-type", (Object)"application/json");
        m.setProperty("eclipselink.json.include-root", (Object)false);
        m.marshal((Object)this.getControlObject9(), os);
        os.flush();
        int response = connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPutJSON(9);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject9(), (Object)testObject);
    }

    public Customer verifyHelperForPostPut(int id) throws Exception {
        URL url = new URL(this.getURL() + "/" + id);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Customer testObject = (Customer)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        connection.disconnect();
        return testObject;
    }

    public Customer verifyHelperForPostPutJSON(int id) throws Exception {
        URL url = new URL(this.getURL() + "/" + id);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        Customer testObject = (Customer)u.unmarshal((Source)json, Customer.class).getValue();
        connection.disconnect();
        return testObject;
    }

    protected Address addressControlObject(int id, String street, String city) {
        Address address = new Address();
        address.setId((long)id);
        address.setStreet(street);
        address.setCity(city);
        return address;
    }

    protected PhoneNumber phoneControlObject(int id, String num, String type, Customer customer) {
        PhoneNumber phoneNumber = new PhoneNumber();
        phoneNumber.setId((long)id);
        phoneNumber.setNum(num);
        phoneNumber.setType(type);
        phoneNumber.setCustomer(customer);
        return phoneNumber;
    }

    protected Customer getControlObject() {
        Customer customer = new Customer();
        customer.setId(1L);
        customer.setFirstName("Jane");
        customer.setLastName("Doe");
        customer.setAddress(this.addressControlObject(1, "1 A Street", "Ottawa"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(1, "555-1111", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(2, "555-2222", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject9() {
        Customer customer = new Customer();
        customer.setId(9L);
        customer.setFirstName("Johnys");
        customer.setLastName("Here");
        customer.setAddress(this.addressControlObject(9, "9 Route", "ManyTown"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(17, "555-1717", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(18, "555-1818", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject8() {
        Customer customer = new Customer();
        customer.setId(8L);
        customer.setFirstName("John");
        customer.setLastName("Does");
        customer.setAddress(this.addressControlObject(8, "8 A Street", "AnyTown"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(15, "555-1515", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(16, "555-1616", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject7() {
        Customer customer = new Customer();
        customer.setId(7L);
        customer.setFirstName("Sophia");
        customer.setLastName("Angelina");
        customer.setAddress(this.addressControlObject(7, "701 kanata lakes", "kanata"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(13, "555-1313", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(14, "555-1414", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject6() {
        Customer customer = new Customer();
        customer.setId(6L);
        customer.setFirstName("Sera");
        customer.setLastName("Quesera");
        customer.setAddress(this.addressControlObject(6, "101 espanol route", "Barcelona"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(11, "555-1111", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(12, "555-1212", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject5() {
        Customer customer = new Customer();
        customer.setId(5L);
        customer.setFirstName("Jack");
        customer.setLastName("Daniel");
        customer.setAddress(this.addressControlObject(5, "5 B Street", "YourTown"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(9, "555-9999", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(10, "555-1010", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject4() {
        Customer customer = new Customer();
        customer.setId(4L);
        customer.setFirstName("John");
        customer.setLastName("Does");
        customer.setAddress(this.addressControlObject(4, "4 A Street", "AnyTown"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(7, "555-7777", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(8, "555-8888", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject3() {
        Customer customer = new Customer();
        customer.setId(3L);
        customer.setFirstName("Sarah");
        customer.setLastName("Smith");
        customer.setAddress(this.addressControlObject(3, "1 Nowhere Drive", "Ottawa"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        PhoneNumber workPhone = new PhoneNumber();
        workPhone.setId(5L);
        workPhone.setNum("555-5555");
        workPhone.setType("WORK");
        workPhone.setCustomer(customer);
        phoneNumbers.add(workPhone);
        PhoneNumber homePhone = new PhoneNumber();
        homePhone.setId(6L);
        homePhone.setNum("555-6666");
        homePhone.setType("HOME");
        homePhone.setCustomer(customer);
        phoneNumbers.add(homePhone);
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject13() {
        Customer customer = new Customer();
        customer.setId(13L);
        customer.setFirstName("Larry");
        customer.setLastName("Robinson");
        customer.setAddress(this.addressControlObject(13, "1 Querbes Avenue", "Montreal"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(25, "555-2525", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(26, "555-2626", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject15() {
        Customer customer = new Customer();
        customer.setId(15L);
        customer.setFirstName("Bob");
        customer.setLastName("Gainey");
        customer.setAddress(this.addressControlObject(15, "15th Avenue", "Montreal"));
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        phoneNumbers.add(this.phoneControlObject(29, "555-2929", "WORK", customer));
        phoneNumbers.add(this.phoneControlObject(30, "555-3030", "HOME", customer));
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customers getControlObjects() {
        Customers customerList = new Customers();
        ArrayList<Customer> customers = new ArrayList<Customer>(2);
        customers.add(this.getControlObject());
        customers.add(this.getControlObject3());
        customerList.setCustomer(customers);
        return customerList;
    }

    protected Customers getControlObjectsJSON() {
        Customers customerList = new Customers();
        ArrayList<Customer> customers = new ArrayList<Customer>(2);
        customers.add(this.getControlObject13());
        customers.add(this.getControlObject15());
        customerList.setCustomer(customers);
        return customerList;
    }

    protected String getID() {
        return "1";
    }

    protected JAXBContext getJAXBContext() {
        return this.jc;
    }

    protected String getURL() {
        return "http://%%host:port%%/CustomerWAR/rest/customer_war";
    }
}

