/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import junit.framework.Test;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.transparentindirection.BidirectionalRelationshipSystem;
import org.eclipse.persistence.testing.models.transparentindirection.CustomIndirectContainerSystem;
import org.eclipse.persistence.testing.models.transparentindirection.Dog;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectListSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectMapSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectSetSystem;
import org.eclipse.persistence.testing.tests.transparentindirection.BidirectionalRelationshipMaintenanceTest;
import org.eclipse.persistence.testing.tests.transparentindirection.ConfigureJavaSE7IndirectCollectionsTest;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestDatabase;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectMapTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectMapTestDatabase;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectSetTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectSetTestDatabase;
import org.eclipse.persistence.testing.tests.transparentindirection.NullCollectionTest;
import org.eclipse.persistence.testing.tests.transparentindirection.NullDelegateInValueHolderTest;
import org.eclipse.persistence.testing.tests.transparentindirection.UpdateDogTest;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class TransparentIndirectionModel
extends TestModel {
    public TransparentIndirectionModel() {
        this.setDescription("Test Transparent Indirection");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new IndirectListSystem());
        this.addRequiredSystem(new IndirectMapSystem());
        this.addRequiredSystem(new IndirectSetSystem());
        this.addRequiredSystem(new CustomIndirectContainerSystem());
        this.addRequiredSystem(new BidirectionalRelationshipSystem());
    }

    public void addTests() {
        Class<?> jdk8impl;
        this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(IndirectList.class, true));
        this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(IndirectList.class, false));
        this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(X.class, false));
        this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(X.class, true));
        if (JavaSEPlatform.atLeast((JavaSEPlatform)JavaSEPlatform.v1_8)) {
            try {
                jdk8impl = Class.forName("org.eclipse.persistence.internal.indirection.jdk8.IndirectList");
                this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(jdk8impl, true));
                this.addTest((Test)IndirectListTestAPI.getTestSuiteFor(jdk8impl, false));
            }
            catch (Throwable t) {
                throw new TestWarningException("JDK 8 impl for IndirectList not found.", t);
            }
        }
        this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(IndirectMap.class, true));
        this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(IndirectMap.class, false));
        this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(Z.class, false));
        this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(Z.class, true));
        if (JavaSEPlatform.atLeast((JavaSEPlatform)JavaSEPlatform.v1_8)) {
            try {
                jdk8impl = Class.forName("org.eclipse.persistence.internal.indirection.jdk8.IndirectMap");
                this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(jdk8impl, true));
                this.addTest((Test)IndirectMapTestAPI.getTestSuiteFor(jdk8impl, false));
            }
            catch (Throwable t) {
                throw new TestWarningException("JDK 8 impl for IndirectMap not found.", t);
            }
        }
        this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(IndirectSet.class, true));
        this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(IndirectSet.class, false));
        this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(Y.class, false));
        this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(Y.class, true));
        if (JavaSEPlatform.atLeast((JavaSEPlatform)JavaSEPlatform.v1_8)) {
            try {
                jdk8impl = Class.forName("org.eclipse.persistence.internal.indirection.jdk8.IndirectSet");
                this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(jdk8impl, true));
                this.addTest((Test)IndirectSetTestAPI.getTestSuiteFor(jdk8impl, false));
            }
            catch (Throwable t) {
                throw new TestWarningException("JDK 8 impl for IndirectSet not found.", t);
            }
        }
        this.addTest((Test)new ZTestSuite(IndirectListTestDatabase.class));
        this.addTest((Test)new ZTestSuite(IndirectMapTestDatabase.class));
        this.addTest((Test)new ZTestSuite(IndirectSetTestDatabase.class));
        this.addTest((Test)this.getCustomIndirectContainerTestSuite());
        this.addTest((Test)this.getBidirectionalRelationshipTestSuite());
        this.addTest((Test)this.getNullDelegateInValueHolderTestSuite());
        this.addTest((Test)this.getJavaSE7IndirectCollectionsConfigurationTestSuite());
    }

    public TestSuite getJavaSE7IndirectCollectionsConfigurationTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JavaSE7IndirectCollectionsConfigurationTestSuite");
        suite.setDescription("This suite tests the configuration of JavaSE 7 Indirect Collections in JavaSE 8.");
        suite.addTest((Test)new ConfigureJavaSE7IndirectCollectionsTest());
        return suite;
    }

    public TestSuite getCustomIndirectContainerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomIndirectContainerTestSuite");
        suite.setDescription("This suite tests custom IndirectContainers.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Dog.class, "Bart")));
        suite.addTest((Test)new UpdateDogTest());
        suite.addTest((Test)new NullCollectionTest());
        return suite;
    }

    public TestSuite getBidirectionalRelationshipTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BidirectionalRelationshipTestSuite");
        suite.setDescription("This suite tests bidirectional relationship maintenance.");
        suite.addTest((Test)new BidirectionalRelationshipMaintenanceTest());
        return suite;
    }

    public TestSuite getNullDelegateInValueHolderTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("NullDelegateInValueHolderTestSuite");
        suite.setDescription("This suite tests setting a ValueHolder in a transparent collection");
        suite.addTest((Test)new NullDelegateInValueHolderTest(IndirectList.class));
        suite.addTest((Test)new NullDelegateInValueHolderTest(IndirectSet.class));
        suite.addTest((Test)new NullDelegateInValueHolderTest(IndirectMap.class));
        return suite;
    }

    public static junit.framework.TestSuite suite() {
        return new TransparentIndirectionModel();
    }

    public static final class Z<K, V>
    extends IndirectMap<K, V> {
    }

    public static final class Y<E>
    extends IndirectSet<E> {
    }

    public static final class X<E>
    extends IndirectList<E> {
    }
}

