/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import java.io.StringWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.StreamSupport;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestAPI;

public class IndirectListTestAPI8
extends IndirectListTestAPI {
    public IndirectListTestAPI8(String name, Class<? extends IndirectList> cls, boolean useListener) {
        super(name, cls, useListener);
    }

    public void testForEach() {
        C c1 = new C();
        C c2 = new C();
        this.list.forEach(c1);
        this.testList.forEach((Consumer)c2);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        IndirectListTestAPI8.assertEquals((String)c1.toString(), (String)c2.toString());
        this.assertNoEvents();
    }

    public void testParallelStream() {
        IndirectListTestAPI8.assertTrue((boolean)this.testList.parallelStream().allMatch(new P(this.list)));
        IndirectListTestAPI8.assertTrue((boolean)this.list.parallelStream().allMatch(new P((List)this.testList)));
        IndirectListTestAPI8.assertEquals((long)this.testList.size(), (long)this.testList.parallelStream().count());
        this.assertNoEvents();
    }

    public void testRemoveIf() {
        IndirectListTestAPI8.assertTrue((boolean)this.list.removeIf(new P2()));
        IndirectListTestAPI8.assertTrue((boolean)this.testList.removeIf((Predicate)new P2()));
        IndirectListTestAPI8.assertEquals((String)"size do not match", (int)8, (int)this.testList.size());
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertRemoveEvents(2);
    }

    public void testReplaceAll() {
        UnaryOperator<String> op = new UnaryOperator<String>(){

            @Override
            public String apply(String s) {
                return s.toUpperCase();
            }
        };
        this.list.replaceAll(op);
        this.testList.replaceAll((UnaryOperator)op);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertRemoveAddEvents(this.testList.size());
    }

    @Override
    public void testSort() {
        this.assertElementsEqual(this.list, (Vector)this.testList);
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        this.list.sort(c);
        this.testList.sort((Comparator)c);
        this.assertElementsEqual(this.list, (Vector)this.testList);
        this.assertNoEvents();
    }

    public void testSpliterator() {
        IndirectListTestAPI8.assertTrue((boolean)StreamSupport.stream(this.testList.spliterator(), true).allMatch(new P(this.list)));
        IndirectListTestAPI8.assertTrue((boolean)StreamSupport.stream(this.list.spliterator(), true).allMatch(new P((List)this.testList)));
        IndirectListTestAPI8.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    public void testStream() {
        IndirectListTestAPI8.assertTrue((boolean)this.testList.stream().allMatch(new P(this.list)));
        IndirectListTestAPI8.assertTrue((boolean)this.list.stream().allMatch(new P((List)this.testList)));
        IndirectListTestAPI8.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    private static final class P2
    implements Predicate<String> {
        private P2() {
        }

        @Override
        public boolean test(String s) {
            return s.startsWith("s");
        }
    }

    private static final class P
    implements Predicate<String> {
        private final List list;

        P(List l) {
            this.list = l;
        }

        @Override
        public boolean test(String s) {
            return this.list.contains(s);
        }
    }

    private static final class C
    implements Consumer<String> {
        private final StringWriter sw = new StringWriter();

        C() {
        }

        @Override
        public void accept(String s) {
            this.sw.append(s);
        }

        public String toString() {
            return this.sw.toString();
        }
    }
}

