/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import java.util.Collection;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectSetTestAPI;

public class IndirectSetTestAPI8
extends IndirectSetTestAPI {
    public IndirectSetTestAPI8(String name, Class<? extends IndirectSet> cls, boolean useListener) {
        super(name, cls, useListener);
    }

    public void testForEach() {
        C c1 = new C();
        C c2 = new C();
        this.list.forEach(c1);
        this.testList.forEach((Consumer)c2);
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        this.assertUnorderedElementsEqual(c1.v, c2.v);
        this.assertNoEvents();
    }

    public void testParallelStream() {
        IndirectSetTestAPI8.assertTrue((boolean)this.testList.parallelStream().allMatch(new P(this.list)));
        IndirectSetTestAPI8.assertTrue((boolean)this.list.parallelStream().allMatch(new P((Collection)this.testList)));
        IndirectSetTestAPI8.assertEquals((long)this.testList.size(), (long)this.testList.parallelStream().count());
        this.assertNoEvents();
    }

    public void testRemoveIf() {
        Predicate<String> p = new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.startsWith("s");
            }
        };
        IndirectSetTestAPI8.assertTrue((boolean)this.list.removeIf(p));
        IndirectSetTestAPI8.assertTrue((boolean)this.testList.removeIf((Predicate)p));
        IndirectSetTestAPI8.assertEquals((String)"size do not match", (int)8, (int)this.testList.size());
        this.assertUnorderedElementsEqual(this.list, new Vector(this.testList));
        this.assertRemoveEvents(2);
    }

    public void testSpliterator() {
        IndirectSetTestAPI8.assertTrue((boolean)StreamSupport.stream(this.testList.spliterator(), true).allMatch(new P(this.list)));
        IndirectSetTestAPI8.assertTrue((boolean)StreamSupport.stream(this.list.spliterator(), true).allMatch(new P((Collection)this.testList)));
        IndirectSetTestAPI8.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    public void testStream() {
        IndirectSetTestAPI8.assertTrue((boolean)this.testList.stream().allMatch(new P(this.list)));
        IndirectSetTestAPI8.assertTrue((boolean)this.list.stream().allMatch(new P((Collection)this.testList)));
        IndirectSetTestAPI8.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    private static final class P
    implements Predicate<String> {
        private final Collection list;

        P(Collection l) {
            this.list = l;
        }

        @Override
        public boolean test(String s) {
            return this.list.contains(s);
        }
    }

    private static final class C
    implements Consumer<String> {
        private final Vector<String> v = new Vector();

        C() {
        }

        @Override
        public void accept(String s) {
            this.v.add(s);
        }
    }
}

