/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CommitAfterExecuteModifyQueryDuringTransTest
extends AutoVerifyTestCase {
    Employee originalEmployee;
    Employee cachedEmployee = null;
    DataModifyQuery dataModifyQuery = null;
    UnitOfWork uow = null;
    String employeesNewFirstName = "";
    Object initialVersionField = null;

    public CommitAfterExecuteModifyQueryDuringTransTest() {
        this.setDescription("Test for successful UOW commit with DataModifyQuery being executed from an event during the transaction");
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("test will not run on RemoteSession - it uses events");
        }
        this.cachedEmployee = (Employee)this.getSession().readObject(Employee.class);
        ClassDescriptor descriptor = this.getSession().getDescriptor((Object)this.cachedEmployee);
        if (descriptor.isProtectedIsolation() && descriptor.shouldIsolateProtectedObjectsInUnitOfWork() && this.getSession() instanceof IsolatedClientSession) {
            this.cachedEmployee = (Employee)((AbstractSession)this.getSession()).getParentIdentityMapSession(descriptor, false, true).getIdentityMapAccessor().getFromIdentityMap((Object)this.cachedEmployee);
        }
        this.originalEmployee = (Employee)this.getSession().copy((Object)this.cachedEmployee);
        this.employeesNewFirstName = "formerlyKnownAs";
        this.initialVersionField = this.getSession().getIdentityMapAccessor().getWriteLockValue((Object)this.cachedEmployee);
        this.dataModifyQuery = new DataModifyQuery("UPDATE EMPLOYEE SET F_NAME = #F_NAME, VERSION = #VERSION WHERE L_NAME = #L_NAME");
        this.dataModifyQuery.addArgument("F_NAME");
        this.dataModifyQuery.addArgument("VERSION");
        this.dataModifyQuery.addArgument("L_NAME");
    }

    public void reset() {
        Vector<Object> myV = new Vector<Object>();
        myV.addElement(this.originalEmployee.firstName);
        myV.addElement(this.initialVersionField);
        myV.addElement(this.originalEmployee.lastName);
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.getSession().executeQuery((DatabaseQuery)this.dataModifyQuery, myV);
        }
        catch (Exception internalException) {
            throw new TestProblemException("Test case may not have cleaned up correctly affecting other tests", (Throwable)internalException);
        }
    }

    public void test() {
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.getEventManager().addListener((SessionEventListener)new SessionEventAdapter(){

            public void prepareUnitOfWork(SessionEvent event) {
                Vector<Object> myV = new Vector<Object>();
                myV.addElement(CommitAfterExecuteModifyQueryDuringTransTest.this.employeesNewFirstName);
                myV.addElement(CommitAfterExecuteModifyQueryDuringTransTest.this.initialVersionField);
                myV.addElement(CommitAfterExecuteModifyQueryDuringTransTest.this.originalEmployee.lastName);
                CommitAfterExecuteModifyQueryDuringTransTest.this.uow.executeQuery((DatabaseQuery)CommitAfterExecuteModifyQueryDuringTransTest.this.dataModifyQuery, myV);
            }
        });
        Employee temp = (Employee)this.uow.registerObject((Object)this.cachedEmployee);
        temp.firstName = "tempFirstName";
        this.uow.commit();
        this.cachedEmployee = (Employee)this.getSession().refreshObject((Object)this.cachedEmployee);
    }

    public void verify() {
        if (!this.employeesNewFirstName.equals(this.cachedEmployee.firstName)) {
            throw new TestErrorException("UOW was not commited when non-selecting SQL was issued during transaction.  Emp First name was not updated");
        }
    }
}

