/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.failover;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.failover.emulateddriver.EmulatedConnection;
import org.eclipse.persistence.testing.tests.failover.emulateddriver.EmulatedDriver;

public class ConnectionPoolFailureTest
extends TestCase {
    protected ServerSession session;

    protected void setup() {
        if (this.getSession().getPlatform().isSymfoware()) {
            this.throwWarning("Test ConnectionPoolFailureTest is not supported on Symfoware, failover has not been implemented on this platform. (bug 304908)");
        }
        Project project = this.getSession().getProject().clone();
        DatabaseLogin login = (DatabaseLogin)project.getLogin().clone();
        login.useDirectDriverConnect();
        login.setDriverClass(EmulatedDriver.class);
        login.setConnectionString("jdbc:emulateddriver");
        project.setLogin(login);
        this.session = (ServerSession)project.createServerSession();
        this.session.setSessionLog(this.getSession().getSessionLog());
        this.session.login();
        String sql = this.getSession().getPlatform().getPingSQL();
        Vector rows = this.getSession().executeSQL(sql);
        ((EmulatedConnection)this.session.getAccessor().getConnection()).putRows(sql, rows);
        ReadObjectQuery query = new ReadObjectQuery(Address.class);
        this.getSession().executeQuery((DatabaseQuery)query);
        sql = query.getSQLString();
        rows = this.getSession().executeSQL(sql);
        ((EmulatedConnection)this.session.getAccessor().getConnection()).putRows(sql, rows);
        ArrayList<Accessor> connections = new ArrayList<Accessor>();
        for (int i = 0; i < 10; ++i) {
            connections.add(this.session.getConnectionPool("default").acquireConnection());
        }
        for (Accessor accessor : connections) {
            this.session.getConnectionPool("default").releaseConnection(accessor);
        }
        List list = this.session.getReadConnectionPool().getConnectionsAvailable();
        for (int i = 0; i < list.size(); ++i) {
            ((EmulatedConnection)((DatabaseAccessor)list.get(i)).getConnection()).causeCommError();
        }
    }

    protected void test() {
        int i;
        for (int i2 = 0; i2 < 4; ++i2) {
            try {
                this.session.acquireClientSession().readObject(Address.class);
                continue;
            }
            catch (DatabaseException ex) {
                throw new TestErrorException("Should have reconnected an not thrown exception.");
            }
        }
        ArrayList<Accessor> connections = new ArrayList<Accessor>();
        for (int i3 = 0; i3 < 10; ++i3) {
            connections.add(this.session.getConnectionPool("default").acquireConnection());
        }
        for (Accessor accessor : connections) {
            this.session.getConnectionPool("default").releaseConnection(accessor);
        }
        List list = this.session.getReadConnectionPool().getConnectionsAvailable();
        for (i = 0; i < list.size(); ++i) {
            ((EmulatedConnection)((DatabaseAccessor)list.get(i)).getConnection()).causeCommError();
        }
        for (i = 0; i < 4; ++i) {
            try {
                ReadObjectQuery query = new ReadObjectQuery(Address.class);
                query.setQueryTimeout(10000);
                this.session.acquireClientSession().executeQuery((DatabaseQuery)query);
                continue;
            }
            catch (DatabaseException ex) {
                if (i == 0) continue;
                throw new TestErrorException("Should have reconnected and not thrown exception.");
            }
        }
    }

    public void reset() {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }
}

