/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.isolatedsession.ClientServerTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;

public class CheckAccessorUsageForIsolatedClass
extends ClientServerTest {
    public IsolatedEmployee readEmployee;

    public CheckAccessorUsageForIsolatedClass() {
        super(false);
        this.setDescription("This test verifies that when an isolated class is queries the correct accessor is used.");
    }

    @Override
    public void test() {
        Session session = (Session)this.clients.get(0);
        if (!(session instanceof IsolatedClientSession)) {
            throw new TestErrorException("The session created was not an Isolated Session");
        }
        Accessor accessor = ((AbstractSession)session).getAccessor();
        ((AbstractSession)session).setAccessor(null);
        String userName = session.getProject().getLogin().getUserName();
        session.getProject().getLogin().setUserName("dumbname");
        UnitOfWork uow = session.acquireUnitOfWork();
        try {
            uow.readObject(IsolatedEmployee.class);
        }
        catch (RuntimeException ex) {
            throw new TestErrorException("TopLink executed call down incorrect accessor");
        }
        finally {
            ((AbstractSession)session).setAccessor(accessor);
            session.getProject().getLogin().setUserName(userName);
        }
    }

    @Override
    public void verify() {
    }
}

