/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class BasicTest
extends AutoVerifyTestCase {
    public static void main(String[] args) throws Throwable {
        BasicTest test = new BasicTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public BasicTest() {
        this.setDescription("Test some basic functions of Helper");
    }

    public void test() {
        if (Helper.compareBigDecimals((BigDecimal)new BigDecimal(0.01), (BigDecimal)new BigDecimal(0.001))) {
            throw new TestErrorException("Failed to compare two different BigDecimal numbers.");
        }
        if (Helper.compareBigDecimals((BigDecimal)new BigDecimal(1.01), (BigDecimal)new BigDecimal(1.001))) {
            throw new TestErrorException("Failed to compare two equal BigDecimal numbers.");
        }
        String path = "c:\\test1\\test2\\test3\\";
        String expectedString = "c:\\\\test1\\\\test2\\\\test3\\\\";
        if (!Helper.doubleSlashes((String)path).equals(expectedString)) {
            throw new TestErrorException("Failed to replace single slash with double slashes from the String.");
        }
        String vowels = "lalelilolule";
        expectedString = "llllll";
        if (!Helper.removeVowels((String)vowels).equals(expectedString)) {
            throw new TestErrorException("Failed to remove vowels from String.");
        }
        String excessCharacterString = "1x2x3x";
        expectedString = "123x";
        if (!Helper.removeCharacterToFit((String)excessCharacterString, (char)'x', (int)4).equals(expectedString)) {
            throw new TestErrorException("Failed to remove Character to fit String.");
        }
        Helper.printTimeFromMilliseconds((long)100L);
        Helper.printTimeFromMilliseconds((long)10000L);
        Helper.printTimeFromMilliseconds((long)100000L);
        if (!(Helper.getInstanceFromClass(((Object)((Object)this)).getClass()) instanceof BasicTest)) {
            throw new TestErrorException("Failed to get instance from Class.");
        }
        if (!(Helper.isPrimitiveWrapper(Character.class) && Helper.isPrimitiveWrapper(Boolean.class) && Helper.isPrimitiveWrapper(Byte.class) && Helper.isPrimitiveWrapper(Short.class) && Helper.isPrimitiveWrapper(Integer.class) && Helper.isPrimitiveWrapper(Long.class) && Helper.isPrimitiveWrapper(Float.class) && Helper.isPrimitiveWrapper(Double.class))) {
            throw new TestErrorException("Failed to check if a class is a primitive wrapper.");
        }
        Vector<Object> aVector = new Vector<Object>();
        BasicTest elem = new BasicTest();
        aVector.addElement((Object)elem);
        if (!Helper.makeVectorFromObject(aVector).equals(aVector)) {
            throw new TestErrorException("Failed to make a java.util.Vector from a java.util.Vector.");
        }
        HashSet<BasicTest> set = new HashSet<BasicTest>();
        set.add(elem);
        if (!Helper.makeVectorFromObject(set).equals(aVector)) {
            throw new TestErrorException("Failed to make a java.util.Vector from a java.util.Set.");
        }
        aVector.clear();
        for (int i = 0; i < 3; ++i) {
            aVector.add(i, new Integer(i));
        }
        Vector reverseVector = Helper.reverseVector(aVector);
        for (int i = 0; i < 3; ++i) {
            if ((Integer)reverseVector.elementAt(i) == 2 - i) continue;
            throw new TestErrorException("Failed to reverse elements of java.util.Vector");
        }
    }
}

