/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.security;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.testing.framework.ReflectionHelper;
import org.eclipse.persistence.testing.framework.TestCase;

public class SecurableBackwardsCompatibilityTest
extends TestCase {
    public SecurableBackwardsCompatibilityTest(String testMethod) {
        this.setName(testMethod);
    }

    public void test() throws Throwable {
        ReflectionHelper.invokeMethod((String)this.getName(), (Object)((Object)this), (Class[])new Class[0], (Object[])new Object[0]);
    }

    public void testStringDecryption_DES_ECB() throws Exception {
        String plainTextString = "welcome123_des_ecb";
        String testString = this.encryptString_DES_ECB(plainTextString);
        SecurableBackwardsCompatibilityTest.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(testString);
        SecurableBackwardsCompatibilityTest.assertEquals((String)"Strings should match.", (String)plainTextString, (String)decryptedString);
    }

    public void testStringDecryption_AES_CBC() throws Exception {
        String plainTextString = "welcome123_aes_cbc";
        JCEEncryptor securable = new JCEEncryptor();
        String testString = securable.encryptPassword(plainTextString);
        SecurableBackwardsCompatibilityTest.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        String decryptedString = securable.decryptPassword(testString);
        SecurableBackwardsCompatibilityTest.assertEquals((String)"Strings should match.", (String)plainTextString, (String)decryptedString);
    }

    public void testStringDecryption_AES_ECB() throws Exception {
        String plainTextString = "welcome123_aes_ecb";
        String testString = this.encryptString_AES_ECB(plainTextString);
        SecurableBackwardsCompatibilityTest.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(testString);
        SecurableBackwardsCompatibilityTest.assertEquals((String)"Strings should match.", (String)plainTextString, (String)decryptedString);
    }

    public void testStringDecryption_PlainText() throws Exception {
        String plainTextString = "welcome123_plaintext";
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(plainTextString);
        SecurableBackwardsCompatibilityTest.assertEquals((String)"Passwords should match.", (String)plainTextString, (String)decryptedString);
    }

    public void testNullParameterDecryption() throws Exception {
        JCEEncryptor securable = new JCEEncryptor();
        String returnValue = securable.decryptPassword(null);
        SecurableBackwardsCompatibilityTest.assertNull((String)"Null should be returned when decrypting a null value", (Object)returnValue);
    }

    public void testNullParameterEncryption() throws Exception {
        ValidationException expectedException = null;
        try {
            JCEEncryptor securable = new JCEEncryptor();
            securable.encryptPassword(null);
        }
        catch (ValidationException ve) {
            expectedException = ve;
        }
        SecurableBackwardsCompatibilityTest.assertNotNull((String)"A ValidationException should be thrown when encrypting a null value", (Object)((Object)expectedException));
    }

    private String encryptString_DES_ECB(String aString) throws Exception {
        byte[] bytes = Helper.buildBytesFromHexString((String)"E60B80C7AEC78038");
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(bytes)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(baos, cipher);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        oos.writeObject(aString);
        oos.flush();
        oos.close();
        return Helper.buildHexStringFromBytes((byte[])baos.toByteArray());
    }

    private String encryptString_AES_ECB(String aString) throws Exception {
        byte[] bytes = Helper.buildBytesFromHexString((String)"3E7CFEF156E712906E1F603B59463C67");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, new SecretKeySpec(bytes, "AES"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(baos, cipher);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        oos.writeObject(aString);
        oos.flush();
        oos.close();
        return Helper.buildHexStringFromBytes((byte[])baos.toByteArray());
    }
}

