/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.LoadBuildSummary;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.ResultInterface;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestResultsSummary;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class TestResult
implements ResultInterface,
Comparable,
Serializable {
    public static final String ERROR = "Error";
    public static final String FATAL_ERROR = "FatalError";
    public static final String PASSED = "Passed";
    public static final String PROBLEM = "Problem";
    public static final String WARNING = "Warning";
    protected String name;
    protected String description;
    protected BigDecimal id;
    protected String outcome;
    protected transient ValueHolderInterface summary;
    protected transient ValueHolderInterface loadBuildSummary;
    protected EclipseLinkException exception;
    protected transient TestCase testCase;
    protected long totalTime;
    protected long testTime;

    public TestResult() {
        this.summary = new ValueHolder();
        this.loadBuildSummary = new ValueHolder();
    }

    public TestResult(TestCase testCase) {
        this.outcome = PASSED;
        this.testCase = testCase;
        try {
            this.name = testCase.getName();
            this.description = testCase.getDescription();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.summary = new ValueHolder();
        this.loadBuildSummary = new ValueHolder();
    }

    public TestResult(TestCase testCase, String result) {
        this.outcome = result;
        this.testCase = testCase;
        this.name = testCase.getName();
        this.description = testCase.getDescription();
        this.summary = new ValueHolder();
        this.loadBuildSummary = new ValueHolder();
    }

    public int compareTo(Object summary) {
        return this.getName().compareTo(((TestResult)summary).getName());
    }

    public String getDescription() {
        return this.description;
    }

    public EclipseLinkException getException() {
        return this.exception;
    }

    @Override
    public boolean shouldLogResult() {
        return !this.hasPassed();
    }

    public String getExceptionStackTraceForDatabase() {
        if (this.exception != null && !this.hasWarning()) {
            StringWriter writer = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            if (trace.length() >= 2000) {
                trace = trace.substring(0, 1995);
            }
            return trace;
        }
        return null;
    }

    public String getExceptionStackTrace() {
        if (this.exception != null) {
            StringWriter writer = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            return trace;
        }
        return null;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public long getTestTime() {
        return this.testTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTestTime(long testTime) {
        this.testTime = testTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public EclipseLinkException getLoadBuildException() {
        return this.exception;
    }

    public LoadBuildSummary getLoadBuildSummary() {
        return (LoadBuildSummary)this.loadBuildSummary.getValue();
    }

    public ValueHolderInterface getLoadBuildSummaryHolder() {
        return this.loadBuildSummary;
    }

    public String getName() {
        return this.name;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getOutcomeForException(EclipseLinkException exception) {
        if (exception == null) {
            return PASSED;
        }
        if (exception instanceof TestErrorException) {
            return ERROR;
        }
        if (exception instanceof TestProblemException) {
            return PROBLEM;
        }
        if (exception instanceof TestWarningException) {
            return WARNING;
        }
        return FATAL_ERROR;
    }

    public TestResultsSummary getSummary() {
        return (TestResultsSummary)this.summary.getValue();
    }

    public ValueHolderInterface getSummaryHolder() {
        return this.summary;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public boolean hasError() {
        return this.getOutcome().equals(ERROR);
    }

    public boolean hasFatalError() {
        return this.getOutcome().equals(FATAL_ERROR);
    }

    @Override
    public boolean hasPassed() {
        return this.getOutcome().equals(PASSED);
    }

    public boolean hasProblem() {
        return this.getOutcome().equals(PROBLEM);
    }

    public boolean hasWarning() {
        return this.getOutcome().equals(WARNING);
    }

    public boolean hasFailed() {
        return !this.hasPassed() && !this.hasWarning();
    }

    public void logRegressionResult(Writer log) {
        String indentationString = this.getTestCase().getIndentationString();
        try {
            log.write(indentationString + "RESULT:      " + this.getOutcome() + Helper.cr());
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoadBuildSystem.loadBuild.addResult(this);
    }

    @Override
    public void logResult(Writer log) {
        String indentationString = this.getTestCase().getIndentationString();
        try {
            if (this.hasError() || this.hasFatalError() || this.hasProblem()) {
                log.write(indentationString + "##FAILURE##" + Helper.cr());
            }
            log.write(indentationString + "TEST TIME:      " + this.getTestTime() + Helper.cr());
            log.write(indentationString + "TOTAL TIME:      " + this.getTotalTime() + Helper.cr());
            log.write(indentationString + "RESULT:      " + this.getOutcome() + Helper.cr());
            if (this.getException() != null) {
                this.getException().setIndentationString(indentationString);
                if (this.hasWarning()) {
                    log.write((Object)((Object)this.getException()) + Helper.cr());
                } else {
                    log.write(indentationString);
                    log.flush();
                    log.write(this.getExceptionStackTrace() + Helper.cr());
                }
            }
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoadBuildSystem.loadBuild.addResult(this);
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public void setException(EclipseLinkException anException) {
        this.exception = anException;
        this.setOutcome(this.getOutcomeForException(anException));
    }

    public void setExceptionStackTrace(String stackTrace) {
        if (stackTrace != null && this.exception == null) {
            this.exception = new TestException(stackTrace);
        }
    }

    public void setId(BigDecimal anId) {
        this.id = anId;
    }

    public void setLoadBuildSummary(LoadBuildSummary summary) {
        if (this.loadBuildSummary == null) {
            this.loadBuildSummary = new ValueHolder();
        }
        this.loadBuildSummary.setValue((Object)summary);
    }

    public void setLoadBuildSummaryHolder(ValueHolderInterface holder) {
        this.loadBuildSummary = holder;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public void setSummary(TestResultsSummary summary) {
        if (this.summary == null) {
            this.summary = new ValueHolder();
        }
        this.summary.setValue((Object)summary);
    }

    public void setSummaryHolder(ValueHolderInterface holder) {
        this.summary = holder;
    }

    public void setupTestResult(TestCase testCase) {
        this.testCase = testCase;
    }
}

