/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class TransactionIsolationTest
extends TestCase {
    protected int level;

    public TransactionIsolationTest() {
        this.setDescription("Tests the transaction isolation setting in login is set on the connection.");
    }

    public void setup() {
        try {
            this.level = ((AbstractSession)this.getSession()).getAccessor().getConnection().getTransactionIsolation();
        }
        catch (Exception exception) {
            throw new TestProblemException("JDBC connection meta-data does not support transaction isolation.", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() {
        DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
        login.setTransactionIsolation(8);
        DatabaseSession testSession = new Project(login).createDatabaseSession();
        testSession.setSessionLog(this.getSession().getSessionLog());
        testSession.login();
        try {
            if (((AbstractSession)testSession).getAccessor().getConnection().getTransactionIsolation() == 8) return;
            throw new TestErrorException("Transaction isolation setting not set on connection.");
        }
        catch (Exception exception) {
            throw new TestProblemException("JDBC connection meta-data does not support transaction isolation.", (Throwable)exception);
        }
        finally {
            try {
                ((AbstractSession)testSession).getAccessor().getConnection().setTransactionIsolation(this.level);
            }
            catch (Exception exception) {
                throw new TestProblemException("JDBC connection meta-data does not support transaction isolation.", (Throwable)exception);
            }
            finally {
                testSession.logout();
            }
        }
    }
}

