/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class OrderByTest
extends JPQLTestCase {
    Collection orderingExpressions = null;

    public static OrderByTest getSimpleOrderByTestAscDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Simple Order By Test Asc Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName").ascending());
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName ASC";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static OrderByTest getSimpleOrderByTestDescDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Simple Order By Test Desc Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName").descending());
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName DESC";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static OrderByTest getSimpleOrderByTestNoDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Simple Order By Test No Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName"));
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static OrderByTest getComplexOrderByNoDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Complex Order By No Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName"));
        test.addOrderingExpression(employee.get("firstName"));
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName, emp.firstName";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static OrderByTest getComplexOrderByAscDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Complex Order By ASC Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName").ascending());
        test.addOrderingExpression(employee.get("firstName").ascending());
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName ASC, emp.firstName ASC";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static OrderByTest getComplexOrderByDescDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Complex Order By Desc Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName").descending());
        test.addOrderingExpression(employee.get("firstName").descending());
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName DESC, emp.firstName DESC";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static OrderByTest getComplexOrderByMixedDirection() {
        OrderByTest test = new OrderByTest();
        test.setName("Complex Order By Mixed Direction");
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("firstName").notEqual((Object)"XXX");
        test.setOriginalObjectExpression(whereClause);
        test.addOrderingExpression(employee.get("lastName").ascending());
        test.addOrderingExpression(employee.get("firstName").descending());
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName <> ";
        ejbqlString = ejbqlString + "\"XXX\" ";
        ejbqlString = ejbqlString + "ORDER BY emp.lastName ASC, emp.firstName DESC";
        test.setEjbqlString(ejbqlString);
        return test;
    }

    public static TestSuite getOrderByTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Order By Test Suite");
        suite.addTest((Test)OrderByTest.getSimpleOrderByTestAscDirection());
        suite.addTest((Test)OrderByTest.getSimpleOrderByTestDescDirection());
        suite.addTest((Test)OrderByTest.getSimpleOrderByTestNoDirection());
        suite.addTest((Test)OrderByTest.getComplexOrderByNoDirection());
        suite.addTest((Test)OrderByTest.getComplexOrderByAscDirection());
        suite.addTest((Test)OrderByTest.getComplexOrderByDescDirection());
        suite.addTest((Test)OrderByTest.getComplexOrderByMixedDirection());
        return suite;
    }

    private void addOrderingExpression(Expression newExpression) {
        this.getOrderingExpressions().add(newExpression);
    }

    @Override
    public void setup() {
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(this.getOriginalObjectExpression());
        Iterator iter = this.getOrderingExpressions().iterator();
        while (iter.hasNext()) {
            raq.addOrdering((Expression)iter.next());
        }
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq));
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        super.setup();
    }

    private Collection getOrderingExpressions() {
        if (this.orderingExpressions == null) {
            this.setOrderingExpression(new Vector());
        }
        return this.orderingExpressions;
    }

    private void setOrderingExpression(Collection newExpressions) {
        this.orderingExpressions = newExpressions;
    }
}

