/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;

public class EclipseLinkASMClassWriter
extends ClassWriter {
    private static final Logger LOG = Logger.getLogger(EclipseLinkASMClassWriter.class.getName());
    private static final int version = EclipseLinkASMClassWriter.getLatestOPCodeVersion();

    public EclipseLinkASMClassWriter() {
        this(2);
    }

    public EclipseLinkASMClassWriter(int flags) {
        super(flags);
    }

    public final void visit(int access, String name, String signature, String superName, String[] interfaces) {
        this.visit(version, access, name, signature, superName, interfaces);
    }

    private static int getLatestOPCodeVersion() {
        String v;
        String latest;
        String oldest;
        LinkedHashMap<String, Integer> versionMap;
        block9: {
            versionMap = new LinkedHashMap<String, Integer>();
            versionMap.put("1.7", 51);
            versionMap.put("1.8", 52);
            versionMap.put("9", 53);
            versionMap.put("10", 54);
            versionMap.put("11", 55);
            versionMap.put("12", 56);
            versionMap.put("13", 57);
            versionMap.put("14", 58);
            versionMap.put("15", 59);
            versionMap.put("16", 60);
            versionMap.put("17", 61);
            ArrayList versions = new ArrayList(versionMap.keySet());
            oldest = (String)versions.get(0);
            latest = (String)versions.get(versions.size() - 1);
            v = oldest;
            if (System.getSecurityManager() == null) {
                v = System.getProperty("java.specification.version");
            } else {
                try {
                    v = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("java.specification.version");
                        }
                    });
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Cannot read 'java.specification.version' property.", t);
                    if (!LOG.isLoggable(Level.FINE)) break block9;
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", v);
                }
            }
        }
        Integer version = (Integer)versionMap.get(v);
        if (version == null) {
            if (latest.compareTo(v) < 0) {
                LOG.log(Level.WARNING, "Java SE ''{0}'' is not fully supported yet. Report this error to the EclipseLink open source project.", v);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", latest);
                }
                version = (Integer)versionMap.get(latest);
            } else {
                String key = oldest;
                LOG.log(Level.WARNING, "Java SE ''{0}'' is too old.", v);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", key);
                }
                version = (Integer)versionMap.get(key);
            }
        }
        return version;
    }
}

