/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject;

import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.glassfish.pfl.basic.logex.OperationTracer;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierBase;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.impl.DefaultClassCopierFactories;
import org.glassfish.pfl.dynamic.copyobject.impl.PipelineClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.spi.ObjectCopier;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;

public class ReflectObjectCopierImpl
implements ObjectCopier {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    static final ThreadLocal localORB = new ThreadLocal();
    private static ClassCopier remoteClassCopier = new ClassCopierBase("remote"){

        public Object createCopy(Object source) {
            com.sun.corba.ee.spi.orb.ORB orb = (com.sun.corba.ee.spi.orb.ORB)localORB.get();
            return Utility.autoConnect(source, (ORB)orb, true);
        }
    };
    private static ClassCopier identityClassCopier = new ClassCopierBase("identity"){

        public Object createCopy(Object source) {
            return source;
        }
    };
    private static ClassCopier corbaClassCopier = new ClassCopierBase("corba"){

        public Object createCopy(Object source) {
            ObjectImpl oi = (ObjectImpl)source;
            Delegate del = oi._get_delegate();
            try {
                ObjectImpl result = (ObjectImpl)source.getClass().newInstance();
                result._set_delegate(del);
                return result;
            }
            catch (Exception exc) {
                throw wrapper.exceptionInCreateCopy(exc);
            }
        }
    };
    private static ClassCopierFactory specialClassCopierFactory = new ClassCopierFactory(){

        public ClassCopier getClassCopier(Class cls) throws ReflectiveCopyException {
            ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(cls);
            if (cinfo.isARemote(cls)) {
                return remoteClassCopier;
            }
            if (cinfo.isAObjectImpl(cls)) {
                return corbaClassCopier;
            }
            if (cinfo.isAORB(cls)) {
                return identityClassCopier;
            }
            return null;
        }
    };
    private static PipelineClassCopierFactory ccf = DefaultClassCopierFactories.getPipelineClassCopierFactory();
    private Map oldToNew;

    public ReflectObjectCopierImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        localORB.set(orb);
        this.oldToNew = new IdentityHashMap();
    }

    public Object copy(Object obj) throws ReflectiveCopyException {
        return this.copy(obj, false);
    }

    public Object copy(Object obj, boolean debug) throws ReflectiveCopyException {
        if (obj == null) {
            return null;
        }
        OperationTracer.begin((String)"ReflectObjectCopierImpl");
        Class<?> cls = obj.getClass();
        ClassCopier copier = ccf.getClassCopier(cls);
        return copier.copy(this.oldToNew, obj);
    }

    static {
        ccf.setSpecialClassCopierFactory(specialClassCopierFactory);
    }
}

