/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class DirectMapMappingDeleteTest
extends AutoVerifyTestCase {
    DirectMapMappings queryResult;

    public DirectMapMappingDeleteTest() {
        this.setDescription("Tests that objects deleted from the properties object in a DirectMapMapping are properly removed.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void test() throws Exception {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps1 = (DirectMapMappings)uow.registerObject((Object)new DirectMapMappings());
        maps1.directMap.put(new Integer(1), "guy");
        maps1.directMap.put(new Integer(2), "axemen");
        uow.commit();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps2 = (DirectMapMappings)uow2.readObject(DirectMapMappings.class);
        maps2.directMap.remove(new Integer(2));
        uow2.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.queryResult = (DirectMapMappings)this.getSession().executeQuery((DatabaseQuery)new ReadObjectQuery(DirectMapMappings.class));
    }

    public void verify() throws Exception {
        if (this.queryResult.directMap.size() != 1) {
            throw new TestErrorException("Deletion from a direct map mapping failed ... object left in database");
        }
    }
}

