/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import junit.framework.TestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.server.JEEPlatform;
import org.eclipse.persistence.testing.framework.server.TestRunner;

@Stateless(name="TestRunner", mappedName="TestRunner")
@Remote(value={TestRunner.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestRunnerBean
implements TestRunner {
    @PersistenceContext(unitName="@puName@")
    private EntityManager entityManager;
    @PersistenceUnit(unitName="@puName@")
    private EntityManagerFactory entityManagerFactory;

    @Override
    public Throwable runTest(String className, String test, Properties props) {
        TestCase testInstance = null;
        try {
            Class<?> testClass = this.getClass().getClassLoader().loadClass(className);
            Constructor<?> c = testClass.getConstructor(String.class);
            testInstance = (TestCase)c.newInstance(test);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException((Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new EJBException((Exception)e);
        }
        catch (InstantiationException e) {
            throw new EJBException((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new EJBException((Exception)e);
        }
        if (props != null) {
            System.getProperties().putAll((Map<?, ?>)props);
        }
        Throwable result = null;
        try {
            if (testInstance instanceof JUnitTestCase) {
                JUnitTestCase jpaTest = (JUnitTestCase)testInstance;
                JEEPlatform.entityManager = this.entityManager;
                JEEPlatform.entityManagerFactory = this.entityManagerFactory;
                jpaTest.runBareServer();
            } else {
                testInstance.runBare();
            }
        }
        catch (Throwable t) {
            result = t;
        }
        return result;
    }
}

