/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsole;
import org.eclipse.persistence.testing.models.optimisticlocking.PowerSupplyUnit;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullTransformationValueTest
extends SwitchableOptimisticLockingPolicyTest {
    protected GamesConsole original;
    protected GamesConsole original2;

    public UpdateNullTransformationValueTest(Class optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(GamesConsole.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new GamesConsole();
        this.original.setPsu(null);
        this.original2 = new GamesConsole();
        this.original2.setName("LookyHere");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit("1"));
            PowerSupplyUnit psu2 = new PowerSupplyUnit("2");
            psu2.setOn(true);
            this.readObjectAndChangeAttributeValue(psu2);
            PowerSupplyUnit psu3 = new PowerSupplyUnit("3");
            psu3.setOn(false);
            this.readObjectAndChangeAttributeValue(psu3);
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit(null));
            this.readObjectAndChangeAttributeValue(null);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
        }
    }

    public void readObjectAndChangeAttributeValue(PowerSupplyUnit psu) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GamesConsole clone = (GamesConsole)uow.readObject(GamesConsole.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullTransformationValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        clone.setPsu(psu);
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

