/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario1_7c
extends ReportQueryTestCase {
    Hashtable realObjects;

    public Scenario1_7c() {
        this.setDescription("Retrieve PKs and use result to get real objects");
    }

    @Override
    protected void buildExpectedResults() {
        Vector phoneNumbers = this.getSession().readAllObjects(PhoneNumber.class);
        this.realObjects = new Hashtable();
        Enumeration e = phoneNumbers.elements();
        while (e.hasMoreElements()) {
            PhoneNumber phone = (PhoneNumber)e.nextElement();
            this.realObjects.put(phone, phone);
            Object[] result = new Object[]{};
            this.addResult(result, this.getSession().getDescriptor(PhoneNumber.class).getObjectBuilder().extractPrimaryKeyFromObject((Object)phone, this.getAbstractSession()));
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(PhoneNumber.class);
        this.reportQuery.retrievePrimaryKeys();
    }

    @Override
    protected void verify() {
        super.verify();
        if (this.results.size() != this.realObjects.size()) {
            throw new TestErrorException("ReportQuery test failed: The result size didn't match the Real Objects");
        }
        for (int index = 0; index < this.results.size(); ++index) {
            ReportQueryResult result = (ReportQueryResult)this.results.elementAt(index);
            PhoneNumber readPhone = (PhoneNumber)result.readObject(PhoneNumber.class, this.getSession());
            if (this.realObjects.contains(readPhone)) continue;
            throw new TestErrorException("ReportQuery test failed: The read objects was not exactly the same as the real.");
        }
    }
}

