/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.io.FileReader;
import java.io.LineNumberReader;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaLoggingOptionsTest
extends AutoVerifyTestCase {
    DatabaseSession employeeSession;
    DatabaseSession employeeSession2;
    DatabaseSession employeeSession3;
    DatabaseSession employeeSession4;
    protected String nullOptionsFileName = "logging-options-null.log";
    protected String defaultFileName = "logging-options-default.log";
    protected String trueFileName = "logging-options-true.log";
    protected String falseFileName = "logging-options-false.log";
    protected String sessionString = "DatabaseSessionImpl";
    protected String connectionString = "Connection";
    protected String threadString = "Thread";
    protected Exception fileReadException = null;

    public SessionsXMLSchemaLoggingOptionsTest() {
        this.setDescription("Test loading of a session xml with various logging options against the XML Schema");
    }

    public void reset() {
        if (this.employeeSession != null && this.employeeSession.isConnected()) {
            this.employeeSession.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession);
            this.employeeSession = null;
        }
        if (this.employeeSession2 != null && this.employeeSession2.isConnected()) {
            this.employeeSession2.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession2);
            this.employeeSession2 = null;
        }
        if (this.employeeSession3 != null && this.employeeSession3.isConnected()) {
            this.employeeSession3.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession3);
            this.employeeSession3 = null;
        }
        if (this.employeeSession4 != null && this.employeeSession4.isConnected()) {
            this.employeeSession4.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession4);
            this.employeeSession4 = null;
        }
    }

    public void test() {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSessionLoggingOptions.xml");
        this.employeeSession = (DatabaseSession)SessionManager.getManager().getSession(loader, "NullOptionsSession", ((Object)((Object)this)).getClass().getClassLoader(), true, false);
        this.employeeSession2 = (DatabaseSession)SessionManager.getManager().getSession(loader, "DefaultSession", ((Object)((Object)this)).getClass().getClassLoader(), true, false);
        this.employeeSession3 = (DatabaseSession)SessionManager.getManager().getSession(loader, "TrueSession", ((Object)((Object)this)).getClass().getClassLoader(), true, false);
        this.employeeSession4 = (DatabaseSession)SessionManager.getManager().getSession(loader, "FalseSession", ((Object)((Object)this)).getClass().getClassLoader(), true, false);
    }

    protected void verify() {
        this.verifyFindStrings(this.sessionString, this.nullOptionsFileName);
        this.verifyFindStrings(this.connectionString, this.nullOptionsFileName);
        this.verifyFindStrings(this.threadString, this.nullOptionsFileName);
        this.verifyFindStrings(this.sessionString, this.defaultFileName);
        this.verifyFindStrings(this.connectionString, this.defaultFileName);
        this.verifyNotFindStrings(this.threadString, this.defaultFileName);
        this.verifyFindStrings(this.sessionString, this.trueFileName);
        this.verifyFindStrings(this.connectionString, this.trueFileName);
        this.verifyFindStrings(this.threadString, this.trueFileName);
        this.verifyNotFindStrings(this.sessionString, this.falseFileName);
        this.verifyNotFindStrings(this.connectionString, this.falseFileName);
        this.verifyNotFindStrings(this.threadString, this.falseFileName);
    }

    protected void verifyFindStrings(String testString, String fileName) {
        if (!this.findStringInFile(testString, fileName)) {
            String exceptionString = "String: " + testString + " not found in " + fileName;
            if (this.fileReadException != null) {
                exceptionString = exceptionString + " Exception thrown while reading file. - " + this.fileReadException.toString();
            }
            throw new TestErrorException(exceptionString);
        }
    }

    protected void verifyNotFindStrings(String testString, String fileName) {
        if (this.findStringInFile(testString, fileName)) {
            String exceptionString = "String: " + testString + " found in " + fileName;
            if (this.fileReadException != null) {
                exceptionString = exceptionString + " Exception thrown while reading file. - " + this.fileReadException.toString();
            }
            throw new TestErrorException(exceptionString);
        }
    }

    public boolean findStringInFile(String string, String fileName) {
        try {
            FileReader reader = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(reader);
            String line = lnr.readLine();
            while (line != null) {
                if (line.indexOf(string) > -1) {
                    return true;
                }
                line = lnr.readLine();
            }
        }
        catch (Exception exception) {
            this.fileReadException = exception;
        }
        return false;
    }
}

