/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockJoinedAttributeTest;

public class PessimisticLockNoLockJoinedTest
extends PessimisticLockJoinedAttributeTest {
    public PessimisticLockNoLockJoinedTest() {
        this.lockMode = (short)2;
        this.setDescription("For bug 3431017 tests when a NO_LOCK query joins an attribute which should be locked.");
    }

    @Override
    public void test() throws Exception {
        if (!this.getSession().getPlatform().isOracle() && !this.getSession().getPlatform().isSQLServer()) {
            throw new TestWarningException("This test only runs on Oracle where writes do not block reads.");
        }
        this.uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(LargeProject.class);
        Expression expression = query.getExpressionBuilder().get("teamLeader").get("firstName").equal((Object)"Charles");
        query.setSelectionCriteria(expression);
        query.addJoinedAttribute(query.getExpressionBuilder().get("teamLeader"));
        query.addJoinedAttribute(query.getExpressionBuilder().get("teamLeader").get("address"));
        query.setLockMode((short)0);
        LargeProject uow1Project = (LargeProject)this.uow.executeQuery((DatabaseQuery)query);
        uow1Project.getTeamLeader().getAddress();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        try {
            boolean isLocked = false;
            LargeProject uow2Project = (LargeProject)uow2.executeQuery((DatabaseQuery)query);
            try {
                uow2Project.getTeamLeader();
            }
            catch (EclipseLinkException exception) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestWarningException("A joined attribute in an explicit NO_LOCK query is not being locked.  This breaks bug 3431017.");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
        }
    }
}

