/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.writing;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class BidirectionalInsertTest
extends AutoVerifyTestCase {
    protected boolean usesUnitOfWork;
    protected Vector originalObjects;

    public BidirectionalInsertTest() {
    }

    public BidirectionalInsertTest(boolean usesUnitOfWork) {
        Object testName = "BidirectionalInsertTest(";
        this.usesUnitOfWork = usesUnitOfWork;
        if (usesUnitOfWork) {
            testName = (String)testName + "with UOW";
        }
        testName = (String)testName + ")";
        this.setName((String)testName);
        this.setDescription("This creates a new set of interrelated employees and projects and commits them.");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
        this.originalObjects = new Vector();
        Employee bob = new Employee();
        bob.setFirstName("Bob");
        Employee fred = new Employee();
        fred.setFirstName("Fred");
        LargeProject prs = new LargeProject();
        prs.setName("PRS");
        prs.setDescription("TOPLink/Smalltalk");
        SmallProject flq = new SmallProject();
        flq.setName("FLQ");
        flq.setDescription("TOPLink/Java");
        fred.addManagedEmployee(bob);
        fred.addProject(flq);
        fred.addProject(prs);
        bob.addManagedEmployee(fred);
        bob.addProject(flq);
        bob.addProject(prs);
        flq.setTeamLeader(bob);
        prs.setTeamLeader(fred);
        this.originalObjects.addElement(bob);
        this.originalObjects.addElement(fred);
        this.originalObjects.addElement(prs);
        this.originalObjects.addElement(flq);
    }

    protected void test() {
        if (this.usesUnitOfWork) {
            UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
            unitOfWork.registerAllObjects((Collection)this.originalObjects);
            unitOfWork.commit();
        } else {
            ((DatabaseSession)this.getSession()).writeAllObjects((Collection)this.originalObjects);
        }
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Vector<Object> databaseObjects = new Vector<Object>();
        Enumeration originalObjectsEnum = this.originalObjects.elements();
        while (originalObjectsEnum.hasMoreElements()) {
            databaseObjects.addElement(this.getSession().readObject(originalObjectsEnum.nextElement()));
        }
        originalObjectsEnum = this.originalObjects.elements();
        Enumeration databaseObjectsEnum = databaseObjects.elements();
        while (originalObjectsEnum.hasMoreElements()) {
            if (this.compareObjects(originalObjectsEnum.nextElement(), databaseObjectsEnum.nextElement())) continue;
            throw new TestErrorException("Objects do not match after insert.");
        }
    }
}

