/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.security.Securable;

public final class JCEEncryptor
implements Securable {
    private String sessionName;
    private static final String DES_ECB = "DES/ECB/PKCS5Padding";
    private final Cipher decryptCipherDES_ECB = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private static final String AES_ECB = "AES/ECB/PKCS5Padding";
    private final Cipher decryptCipherAES_ECB;
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private final Cipher decryptCipherAES_CBC;
    private static final byte IV_GCM_LENGTH = 16;
    private static final String AES_GCM = "AES/GCM/NoPadding";
    private final Cipher encryptCipherAES_GCM;
    private final Cipher decryptCipherAES_GCM;

    public JCEEncryptor() throws Exception {
        this.decryptCipherDES_ECB.init(2, Synergizer.getDESMultitasker());
        this.decryptCipherAES_ECB = Cipher.getInstance(AES_ECB);
        this.decryptCipherAES_ECB.init(2, Synergizer.getAESMultitasker());
        SecretKey sk = Synergizer.getAESCBCMultitasker();
        IvParameterSpec iv = Synergizer.getIvSpec();
        this.decryptCipherAES_CBC = Cipher.getInstance(AES_CBC);
        this.decryptCipherAES_CBC.init(2, (Key)sk, iv);
        this.encryptCipherAES_GCM = Cipher.getInstance(AES_GCM);
        this.decryptCipherAES_GCM = Cipher.getInstance(AES_GCM);
    }

    @Override
    public synchronized String encryptPassword(String password) {
        try {
            byte[] ivGCM = Synergizer.getIvGCM();
            GCMParameterSpec parameterSpecGCM = new GCMParameterSpec(128, ivGCM);
            SecretKey skGCM = Synergizer.getAESGCMMultitasker();
            this.encryptCipherAES_GCM.init(1, (Key)skGCM, parameterSpecGCM);
            byte[] bytePassword = this.encryptCipherAES_GCM.doFinal(password.getBytes("UTF-8"));
            byte[] result = Arrays.copyOf(ivGCM, 16 + bytePassword.length);
            System.arraycopy(bytePassword, 0, result, 16, bytePassword.length);
            return Helper.buildHexStringFromBytes(result);
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    @Override
    public synchronized String decryptPassword(String encryptedPswd) {
        String password;
        block39: {
            if (encryptedPswd == null) {
                return null;
            }
            password = null;
            byte[] input = null;
            byte[] bytePassword = null;
            try {
                input = Helper.buildBytesFromHexString(encryptedPswd);
                SecretKey skGCM = Synergizer.getAESGCMMultitasker();
                byte[] ivGCM = new byte[16];
                System.arraycopy(input, 0, ivGCM, 0, 16);
                GCMParameterSpec parameterSpecGCM = new GCMParameterSpec(128, ivGCM);
                bytePassword = new byte[input.length - 16];
                System.arraycopy(input, 16, bytePassword, 0, input.length - 16);
                this.decryptCipherAES_GCM.init(2, (Key)skGCM, parameterSpecGCM);
                password = new String(this.decryptCipherAES_GCM.doFinal(bytePassword), "UTF-8");
            }
            catch (IllegalBlockSizeException | ConversionException ce) {
                password = encryptedPswd;
            }
            catch (Exception u) {
                try {
                    if (this.sessionName != null) {
                        AbstractSessionLog.getLog().log(6, "jpa", "encryptor_decrypt_old_algorithm", new Object[]{this.sessionName});
                    } else {
                        AbstractSessionLog.getLog().log(6, "jpa", "encryptor_decrypt_old_algorithm_without_session_name", null);
                    }
                    bytePassword = Helper.buildBytesFromHexString(encryptedPswd);
                    password = new String(this.decryptCipherAES_CBC.doFinal(bytePassword), "UTF-8");
                }
                catch (Exception w) {
                    ObjectInputStream oisAes = null;
                    try {
                        try {
                            oisAes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherAES_ECB));
                            password = (String)oisAes.readObject();
                        }
                        catch (Exception x) {
                            block38: {
                                ObjectInputStream oisDes = null;
                                try {
                                    oisDes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherDES_ECB));
                                    password = (String)oisDes.readObject();
                                }
                                catch (ArrayIndexOutOfBoundsException y) {
                                    password = encryptedPswd;
                                    if (oisDes != null) {
                                        try {
                                            oisDes.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    break block38;
                                }
                                catch (Exception z) {
                                    try {
                                        if (z.getCause() instanceof IllegalBlockSizeException) {
                                            password = encryptedPswd;
                                            break block38;
                                        }
                                        throw ValidationException.errorDecryptingPassword(z);
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        if (oisDes != null) {
                                            try {
                                                oisDes.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                if (oisDes == null) break block38;
                                try {
                                    oisDes.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (oisAes == null) break block39;
                            try {
                                oisAes.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    finally {
                        if (oisAes != null) {
                            try {
                                oisAes.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
        return password;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getDESMultitasker() throws Exception {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            return factory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }

        private static SecretKey getAESMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("3E7CFEF156E712906E1F603B59463C67"), "AES");
        }

        private static SecretKey getAESCBCMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("2DB7354A48F1CA7B48ACA247540FC923"), "AES");
        }

        private static SecretKey getAESGCMMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("64EF2D9B738ACA254A48F14754030FC2"), "AES");
        }

        private static IvParameterSpec getIvSpec() {
            byte[] b = new byte[]{-26, 124, -99, 32, -37, -58, -93, 100, 126, -55, -21, 48, -86, 97, 12, 113};
            return new IvParameterSpec(b);
        }

        private static byte[] getIvGCM() {
            byte[] ivGCM = new byte[16];
            SecureRandom random = null;
            try {
                random = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            random.nextBytes(ivGCM);
            return ivGCM;
        }
    }
}

