/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.Oracle11Platform;

public class Oracle12Platform
extends Oracle11Platform {
    public Struct createStruct(String structTypeName, Object[] attributes, AbstractRecord row, Vector orderedFields, AbstractSession session, Connection connection) throws SQLException {
        int index = 0;
        while (index < orderedFields.size()) {
            DatabaseField field = (DatabaseField)orderedFields.elementAt(index);
            if (row.getField(field) != null && row.getField(field).getTypeName() != null) {
                if (ClassConstants.BLOB.getTypeName().equals(row.getField(field).getTypeName())) {
                    Blob blob = connection.createBlob();
                    blob.setBytes(1L, (byte[])row.get(field));
                    attributes[index] = blob;
                } else if (ClassConstants.CLOB.getTypeName().equals(row.getField(field).getTypeName())) {
                    Clob clob = connection.createClob();
                    clob.setString(1L, (String)attributes[index]);
                    attributes[index] = clob;
                }
            } else {
                attributes[index] = row.get(field);
            }
            ++index;
        }
        return this.createStruct(structTypeName, attributes, connection);
    }

    @Override
    public Struct createStruct(String structTypeName, Object[] attributes, Connection connection) throws SQLException {
        return connection.createStruct(structTypeName, attributes);
    }
}

