/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMMultipleFlushTests
extends EntityContainerTestBase {
    protected boolean reset = false;
    public Integer[] empIDs = new Integer[4];
    public Integer[] projIDs = new Integer[2];
    public Integer[] addrIDs = new Integer[2];
    public ArrayList phones = new ArrayList(2);
    public HashMap removedPhone = new HashMap(4);
    public HashMap removedAddress = new HashMap(4);

    public EMMultipleFlushTests() {
        this.setDescription("Test flush multiple times in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
        Employee empClone1 = ModelExamples.employeeExample1();
        empClone1.setAddress(ModelExamples.addressExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample9());
        Employee empClone2 = ModelExamples.employeeExample2();
        empClone2.setAddress(ModelExamples.addressExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample8());
        Employee empClone3 = ModelExamples.employeeExample3();
        empClone3.setAddress(ModelExamples.addressExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample7());
        Employee empClone4 = ModelExamples.employeeExample4();
        Address addrClone5 = ModelExamples.addressExample5();
        empClone4.setAddress(addrClone5);
        addrClone5.getEmployees().add(empClone4);
        empClone1.addManagedEmployee(empClone2);
        empClone1.addManagedEmployee(empClone3);
        Project projClone1 = ModelExamples.projectExample1();
        Project projClone2 = ModelExamples.projectExample2();
        projClone1.setTeamLeader(empClone1);
        projClone1.addTeamMember(empClone1);
        projClone1.addTeamMember(empClone2);
        projClone1.addTeamMember(empClone3);
        empClone1.addProject(projClone1);
        empClone2.addProject(projClone1);
        empClone3.addProject(projClone1);
        Address addrClone = ModelExamples.addressExample4();
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)empClone1);
            this.getEntityManager().persist((Object)empClone2);
            this.getEntityManager().persist((Object)empClone3);
            this.getEntityManager().persist((Object)projClone1);
            this.getEntityManager().persist((Object)projClone2);
            this.getEntityManager().persist((Object)addrClone);
            this.getEntityManager().persist((Object)empClone4);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestException("Unable to setup Test" + ex);
        }
        this.empIDs[0] = empClone1.getId();
        this.empIDs[1] = empClone2.getId();
        this.empIDs[2] = empClone3.getId();
        this.empIDs[3] = empClone4.getId();
        this.projIDs[0] = projClone1.getId();
        this.projIDs[1] = projClone2.getId();
        this.addrIDs[0] = addrClone.getID();
        this.addrIDs[1] = addrClone5.getID();
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.phones.clear();
            this.reset = false;
        }
        super.reset();
    }

    public void test() {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
            Employee employee4 = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[3]);
            Project project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[1]);
            Address address = (Address)this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]);
            Address address5 = (Address)this.getEntityManager().find(Address.class, (Object)this.addrIDs[1]);
            address5.getEmployees().size();
            project.addTeamMember(employee);
            employee.addProject(project);
            PhoneNumber phone = (PhoneNumber)employee.getPhoneNumbers().iterator().next();
            employee.getPhoneNumbers().remove(phone);
            this.phones.add(phone.buildPK());
            this.removedPhone.put("before remove", this.getEntityManager().find(PhoneNumber.class, this.phones.get(0)));
            this.removedAddress.put("before remove", this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]));
            this.getEntityManager().remove((Object)phone);
            this.getEntityManager().remove((Object)address);
            this.getEntityManager().remove((Object)employee4);
            this.removedPhone.put("after remove", this.getEntityManager().find(PhoneNumber.class, this.phones.get(0)));
            this.removedAddress.put("after remove", this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]));
            this.getEntityManager().flush();
            this.removedPhone.put("after first flush", this.getEntityManager().find(PhoneNumber.class, this.phones.get(0)));
            this.removedAddress.put("after first flush", this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]));
            phone = (PhoneNumber)employee.getPhoneNumbers().iterator().next();
            employee.getPhoneNumbers().remove(phone);
            this.phones.add(phone.buildPK());
            this.getEntityManager().remove((Object)phone);
            employee.setLastName("Fourlang");
            this.getEntityManager().flush();
            this.getEntityManager().remove((Object)address5);
            this.removedPhone.put("after second flush", this.getEntityManager().find(PhoneNumber.class, this.phones.get(0)));
            this.removedAddress.put("after second flush", this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]));
            employee.setSalary(20000);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring flushing of Employee", (Throwable)ex);
        }
    }

    public void verify() {
        Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
        if (!employee.getLastName().equals("Fourlang")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Last Name not Updated");
        }
        if (employee.getSalary() != 20000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Salary Not Updated");
        }
        if (((Project)employee.getProjects().iterator().next()).getId().equals(this.projIDs[1])) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Project not added");
        }
        if (employee.getPhoneNumbers().size() != 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Phones Not Deleted");
        }
        PhoneNumber phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, this.phones.get(0));
        if (phone != null) {
            throw new TestErrorException("Phone ID :" + this.phones.get(0) + " not deleted");
        }
        phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, this.phones.get(1));
        if (phone != null) {
            throw new TestErrorException("Phone ID :" + this.phones.get(1) + " not deleted");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
        if (!employee.getLastName().equals("Fourlang")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Last Name not Updated on Database");
        }
        if (employee.getSalary() != 20000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Salary Not Updated on Database");
        }
        if (employee.getProjects().size() != 2) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Project not added on Database");
        }
        if (employee.getPhoneNumbers().size() != 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Phones Not Deleted on Database");
        }
        phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, this.phones.get(0));
        if (phone != null) {
            throw new TestErrorException("Phone ID :" + this.phones.get(0) + " not deleted on Database");
        }
        phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, this.phones.get(1));
        if (phone != null) {
            throw new TestErrorException("Phone ID :" + this.phones.get(1) + " not deleted on Database");
        }
        if (this.removedPhone.get("before remove") == null) {
            throw new TestErrorException("Find before remove: Phone ID :" + this.phones.get(0) + " is not found");
        }
        if (this.removedPhone.get("after remove") != null) {
            throw new TestErrorException("Find after remove: Phone ID :" + this.phones.get(0) + " is found");
        }
        if (this.removedPhone.get("after first flush") != null) {
            throw new TestErrorException("Find after first flush: Phone ID :" + this.phones.get(0) + " is found");
        }
        if (this.removedPhone.get("after second flush") != null) {
            throw new TestErrorException("Find after second flush: Phone ID :" + this.phones.get(0) + " is found");
        }
        if (this.removedAddress.get("before remove") == null) {
            throw new TestErrorException("Find before remove: Address ID :" + this.addrIDs[0] + " is not found");
        }
        if (this.removedAddress.get("after remove") != null) {
            throw new TestErrorException("Find after remove: Address ID :" + this.addrIDs[0] + " is found");
        }
        if (this.removedAddress.get("after first flush") != null) {
            throw new TestErrorException("Find after first flush: Address ID :" + this.addrIDs[0] + " is found");
        }
        if (this.removedAddress.get("after second flush") != null) {
            throw new TestErrorException("Find after second flush: Address ID :" + this.addrIDs[0] + " is found");
        }
    }
}

